/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.utils.Color;

@OnlyIn(value=Dist.CLIENT)
public final class GearClientHelper {
    private GearClientHelper() {
    }

    public static int getColor(ItemStack stack, PartType layer) {
        PartData part = GearData.getPartOfType(stack, layer);
        if (part != null) {
            return part.getColor(stack, 0, 0);
        }
        return 0xFFFFFF;
    }

    public static void addInformation(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        GearTooltipFlag flagTC = flag instanceof GearTooltipFlag ? (GearTooltipFlag)flag : GearTooltipFlag.withModifierKeys(flag.func_194127_a(), true, true);
        GearClientHelper.addInformation(stack, world, tooltip, flagTC);
    }

    public static void addInformation(ItemStack stack, World world, List<ITextComponent> tooltip, GearTooltipFlag flag) {
        PartDataList constructionParts;
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            return;
        }
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        if (GearHelper.isBroken(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), (ITextComponent)TextUtil.withColor(GearClientHelper.misc("broken", new Object[0]), Color.FIREBRICK));
        }
        if (GearData.isExampleGear(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), (ITextComponent)TextUtil.withColor(GearClientHelper.misc("exampleOutput1", new Object[0]), Color.YELLOW));
            tooltip.add(Math.min(2, tooltip.size()), (ITextComponent)TextUtil.withColor(GearClientHelper.misc("exampleOutput2", new Object[0]), Color.YELLOW));
        }
        if ((constructionParts = GearData.getConstructionParts(stack)).getMains().isEmpty()) {
            tooltip.add((ITextComponent)TextUtil.withColor(GearClientHelper.misc("invalidParts", new Object[0]), Color.FIREBRICK));
            tooltip.add((ITextComponent)TextUtil.withColor(GearClientHelper.misc("lockedStats", new Object[0]), Color.FIREBRICK));
        } else if (GearData.hasLockedStats(stack)) {
            tooltip.add((ITextComponent)TextUtil.withColor(GearClientHelper.misc("lockedStats", new Object[0]), Color.YELLOW));
        }
        Collections.reverse(constructionParts);
        for (PartData data : constructionParts) {
            data.get().addInformation(data, stack, tooltip, flag);
        }
        GearClientHelper.addTraitsInfo(stack, tooltip, flag);
        GearClientHelper.addStatsInfo(stack, tooltip, flag, item);
        if (KeyTracker.isDisplayConstructionDown() && flag.showConstruction) {
            tooltip.add((ITextComponent)TextUtil.withColor(GearClientHelper.misc("tooltip.construction", new Object[0]), Color.GOLD));
            Collections.reverse(constructionParts);
            GearClientHelper.tooltipListParts(stack, tooltip, constructionParts, flag);
        } else if (flag.showConstruction) {
            tooltip.add((ITextComponent)TextUtil.withColor(TextUtil.misc("tooltip.construction", new Object[0]), Color.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_CONSTRUCTION), TextFormatting.GRAY))));
        }
    }

    public static void addStatsInfo(ItemStack stack, List<ITextComponent> tooltip, GearTooltipFlag flag, ICoreItem item) {
        if (KeyTracker.isDisplayStatsDown() && flag.showStats) {
            tooltip.add((ITextComponent)TextUtil.withColor(GearClientHelper.misc("tooltip.stats", new Object[0]), Color.GOLD));
            tooltip.add((ITextComponent)TextUtil.withColor(GearClientHelper.misc("tier", GearData.getTier(stack)), Color.DEEPSKYBLUE));
            Set<ItemStat> relevantStats = item.getRelevantStats(stack);
            Set<ItemStat> displayStats = flag.func_194127_a() && SilentGear.isDevBuild() ? ItemStats.allStatsOrdered() : relevantStats;
            TextListBuilder builder = new TextListBuilder();
            for (ItemStat stat : displayStats) {
                float statValue = GearData.getStat(stack, stat);
                StatInstance inst = StatInstance.of(statValue, StatInstance.Operation.AVG, StatInstance.DEFAULT_KEY);
                Color nameColor = relevantStats.contains(stat) ? stat.getNameColor() : TooltipHandler.MC_DARK_GRAY;
                IFormattableTextComponent textName = TextUtil.withColor(stat.getDisplayName(), nameColor);
                IFormattableTextComponent textStat = inst.getFormattedText(stat, stat.isDisplayAsInt() ? 0 : 2, false);
                if (stat == ItemStats.DURABILITY) {
                    int durabilityLeft = stack.func_77958_k() - stack.func_77952_i();
                    int durabilityMax = stack.func_77958_k();
                    textStat = GearClientHelper.statText("durabilityFormat", durabilityLeft, durabilityMax);
                } else if (stat == ItemStats.HARVEST_LEVEL) {
                    textStat = TooltipHandler.harvestLevelWithHint(textStat, statValue);
                }
                builder.add((ITextComponent)GearClientHelper.statText("displayFormat", textName, textStat));
            }
            tooltip.addAll(builder.build());
        } else if (flag.showStats) {
            tooltip.add((ITextComponent)TextUtil.withColor(TextUtil.misc("tooltip.stats", new Object[0]), Color.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), TextFormatting.GRAY))));
        }
    }

    private static void addTraitsInfo(ItemStack stack, List<ITextComponent> tooltip, GearTooltipFlag flag) {
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(stack);
        ArrayList<ITrait> visibleTraits = new ArrayList<ITrait>();
        for (ITrait t : traits.keySet()) {
            if (t == null || !t.showInTooltip(flag)) continue;
            visibleTraits.add(t);
        }
        int traitIndex = GearClientHelper.getTraitDisplayIndex(visibleTraits.size(), flag);
        IFormattableTextComponent textTraits = TextUtil.withColor(GearClientHelper.misc("tooltip.traits", new Object[0]), Color.GOLD);
        if (traitIndex < 0) {
            tooltip.add((ITextComponent)textTraits);
        }
        int i = 0;
        for (ITrait trait : visibleTraits) {
            if (traitIndex < 0 || traitIndex == i) {
                int level = traits.get(trait);
                trait.addInformation(level, tooltip, flag, text -> {
                    if (traitIndex >= 0) {
                        return textTraits.func_230529_a_((ITextComponent)TextUtil.withColor((IFormattableTextComponent)new StringTextComponent(": "), TextFormatting.GRAY).func_230529_a_(text));
                    }
                    return new StringTextComponent(TextListBuilder.BULLETS[0] + " ").func_230529_a_(text);
                });
            }
            ++i;
        }
    }

    private static int getTraitDisplayIndex(int numTraits, GearTooltipFlag flag) {
        if (KeyTracker.isDisplayTraitsDown() || numTraits == 0) {
            return -1;
        }
        return ClientTicks.ticksInGame() / 20 % numTraits;
    }

    private static IFormattableTextComponent misc(String key, Object ... formatArgs) {
        return new TranslationTextComponent("misc.silentgear." + key, formatArgs);
    }

    private static IFormattableTextComponent statText(String key, Object ... formatArgs) {
        return new TranslationTextComponent("stat.silentgear." + key, formatArgs);
    }

    public static void tooltipListParts(ItemStack gear, List<ITextComponent> tooltip, Collection<PartData> parts, GearTooltipFlag flag) {
        TextListBuilder builder = new TextListBuilder();
        for (PartData part : parts) {
            if (!part.get().isVisible()) continue;
            int partNameColor = Color.blend((int)part.getColor(gear), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            IFormattableTextComponent partNameText = TextUtil.withColor(part.getDisplayName(gear).func_230532_e_(), partNameColor);
            builder.add((ITextComponent)(flag.func_194127_a() ? partNameText.func_230529_a_((ITextComponent)TextUtil.misc("spaceBrackets", part.getType().getName()).func_240699_a_(TextFormatting.DARK_GRAY)) : partNameText));
            if (!(part.get() instanceof CompoundPart)) continue;
            builder.indent();
            for (IMaterialInstance material : CompoundPartItem.getMaterials(part.getItem())) {
                int nameColor = material.getNameColor(part.getType(), GearType.ALL);
                builder.add((ITextComponent)TextUtil.withColor(material.getDisplayNameWithGrade(part.getType(), ItemStack.field_190927_a), nameColor));
            }
            builder.unindent();
        }
        tooltip.addAll(builder.build());
    }

    public static boolean hasEffect(ItemStack stack) {
        return (Boolean)Config.Client.allowEnchantedEffect.get() != false && stack.func_77948_v();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }
}

