/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.network.ClientOutputCommandPacket;
import net.silentchaos512.gear.network.Network;

public final class MaterialsCommand {
    private static final SuggestionProvider<CommandSource> MATERIAL_ID_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(MaterialManager.getValues().stream().map(IMaterial::getId), (SuggestionsBuilder)builder);
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private MaterialsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"sgear_mats");
        builder.then(Commands.func_197057_a((String)"list").executes(MaterialsCommand::runList));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump").then(Commands.func_197056_a((String)"includeChildren", (ArgumentType)BoolArgumentType.bool()).executes(context -> MaterialsCommand.runDump((CommandContext<CommandSource>)context, (Boolean)context.getArgument("includeChildren", Boolean.class))))).executes(context -> MaterialsCommand.runDump((CommandContext<CommandSource>)context, true)));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = MaterialManager.getValues().stream().map(mat -> mat.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        return 1;
    }

    private static int runDump(CommandContext<CommandSource> context, boolean includeChildren) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        SilentGear.LOGGER.info("Send material dump packet to client {}", (Object)player.func_195047_I_());
        ClientOutputCommandPacket message = new ClientOutputCommandPacket(ClientOutputCommandPacket.Type.MATERIALS, includeChildren);
        Network.channel.sendTo((Object)message, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDumpClient(boolean includeChildren) {
        PlayerEntity player = SilentGear.PROXY.getClientPlayer();
        if (player == null) {
            SilentGear.LOGGER.error("MaterialsCommand#runDumpClient: player is null?");
            return;
        }
        String dirPath = "output/silentgear";
        String fileName = "material_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Could not create directory: " + output.getParent()), Util.field_240973_b_);
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Pack\tName\tType\tID\tParent\tTraits\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().getString()).append("\t"));
            writer.write(builder + "\n");
            ArrayList<PartType> partTypes = new ArrayList<PartType>(PartType.getValues());
            partTypes.sort((o1, o2) -> Comparator.comparing(o -> ((PartType)o).getDisplayName(0).getString()).compare(o1, o2));
            for (PartType partType : partTypes) {
                for (IMaterial material : MaterialManager.getValues()) {
                    MaterialInstance inst;
                    if (!includeChildren && !MaterialsCommand.getParentId(material).isEmpty() || !material.allowedInPart(inst = MaterialInstance.of(material), partType)) continue;
                    writer.write(MaterialsCommand.makeTsvLine(inst, partType) + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IFormattableTextComponent fileNameText = new StringTextComponent(output.getAbsolutePath()).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            player.func_145747_a((ITextComponent)new StringTextComponent("Wrote materials info to ").func_230529_a_((ITextComponent)fileNameText), Util.field_240973_b_);
        }
    }

    private static String makeTsvLine(MaterialInstance material, PartType partType) {
        StringBuilder builder = new StringBuilder();
        MaterialsCommand.appendTsv(builder, material.get().getPackName());
        MaterialsCommand.appendTsv(builder, material.getDisplayName(partType).getString());
        int tier = material.getTier(partType);
        MaterialsCommand.appendTsv(builder, partType.getDisplayName(0).getString());
        MaterialsCommand.appendTsv(builder, material.getId().toString());
        MaterialsCommand.appendTsv(builder, MaterialsCommand.getParentId(material.get()));
        MaterialsCommand.appendTsv(builder, material.getTraits(partType).stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).getString()).collect(Collectors.joining(", ")));
        MaterialsCommand.appendTsv(builder, tier);
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = material.getStatModifiers(partType, StatGearKey.of(stat, GearType.ALL));
            MaterialsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        return builder.toString();
    }

    private static String getParentId(IMaterial material) {
        IMaterial parent = material.getParent();
        if (parent != null) {
            return parent.getId().toString();
        }
        return "";
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static ITextComponent text(String key, Object ... args) {
        return new TranslationTextComponent("command.silentgear.parts." + key, args);
    }
}

