/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.PlayerUtils;

public final class StatsCommand {
    private StatsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sgear_stats").requires(source -> source.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> StatsCommand.runInfo((CommandContext<CommandSource>)ctx, EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"))))).executes(ctx -> StatsCommand.runInfo((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"lock").executes(StatsCommand::runLockStats))).then(Commands.func_197057_a((String)"recalculate").then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> StatsCommand.runRecalculate((CommandContext<CommandSource>)ctx, EntityArgument.func_197090_e((CommandContext)ctx, (String)"players"))))));
    }

    private static int runInfo(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (!GearHelper.isGear(stack)) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)TextUtil.translate("command", "invalidItemType", stack.func_200301_q()));
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TextUtil.translate("command", "stats.info.header", player.func_200200_C_(), stack.func_200301_q()).func_240699_a_(TextFormatting.BOLD), true);
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        PartDataList parts = GearData.getConstructionParts(stack);
        StatModifierMap stats = GearData.getStatModifiers(stack, item, parts);
        for (ItemStat stat : ItemStats.allStatsOrderedExcluding(item.getExcludedStats(stack))) {
            StatGearKey key = StatGearKey.of(stat, item.getGearType());
            Collection<StatInstance> mods = stats.get(key);
            if (mods.isEmpty()) continue;
            IFormattableTextComponent name = TextUtil.withColor(stat.getDisplayName(), stat.getNameColor());
            IFormattableTextComponent modsText = StatModifierMap.formatText(mods, stat, 5, true);
            float statValue = stat.compute(0.0f, true, item.getGearType(), mods);
            IFormattableTextComponent valueText = TextUtil.withColor(StatInstance.of(statValue, StatInstance.Operation.AVG, key).getFormattedText(stat, 5, false), TextFormatting.YELLOW);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TextUtil.translate("command", "stats.info.format", name, modsText, valueText), true);
            for (PartData part : parts) {
                Collection<StatInstance> partMods = part.getStatModifiers(key, stack);
                if (partMods.isEmpty()) continue;
                ITextComponent partName = part.getDisplayName(stack);
                IFormattableTextComponent partModsText = StatModifierMap.formatText(partMods, stat, 5, true);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TextUtil.translate("command", "stats.info.formatPart", partName, partModsText), true);
            }
        }
        return 1;
    }

    private static int runLockStats(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity playerMP = ((CommandSource)context.getSource()).func_197035_h();
        ItemStack stack = playerMP.func_184614_ca();
        if (GearHelper.isGear(stack)) {
            boolean locked = !GearData.hasLockedStats(stack);
            GearData.setLockedStats(stack, locked);
            String translationKey = "command.silentgear.lock_stats." + (locked ? "locked" : "unlocked");
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(translationKey, new Object[]{stack.func_200301_q()}), true);
        } else {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentgear.lock_stats.invalid"));
        }
        return 1;
    }

    private static int runRecalculate(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            for (ItemStack stack : PlayerUtils.getNonEmptyStacks((PlayerEntity)player)) {
                if (!GearHelper.isGear(stack)) continue;
                GearData.recalculateStats(stack, (PlayerEntity)player);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.silentgear.recalculate", new Object[]{player.func_195047_I_()}), true);
        }
        return 1;
    }
}

