/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public final class GearPartIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType type;

    private GearPartIngredient(PartType type) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.type = type;
    }

    public static GearPartIngredient of(PartType type) {
        return new GearPartIngredient(type);
    }

    @Override
    public PartType getPartType() {
        return this.type;
    }

    @Override
    public Optional<ITextComponent> getJeiHint() {
        StringTextComponent typeText = new StringTextComponent(this.type.getShortName());
        IFormattableTextComponent text = TextUtil.withColor((IFormattableTextComponent)typeText, Color.GOLD);
        return Optional.of(TextUtil.translate("jei", "partType", text));
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        PartData part = PartData.from(stack);
        return part != null && part.getType().equals(this.type);
    }

    public ItemStack[] func_193365_a() {
        List<IGearPart> parts = PartManager.getPartsOfType(this.type);
        if (!parts.isEmpty()) {
            return (ItemStack[])parts.stream().flatMap(part -> Stream.of(part.getIngredient().func_193365_a())).filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
        }
        return super.func_193365_a();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean func_203189_d() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("part_type", this.type.getName().toString());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<GearPartIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("silentgear", "part_type");

        private Serializer() {
        }

        public GearPartIngredient parse(PacketBuffer buffer) {
            ResourceLocation typeName = buffer.func_192575_l();
            PartType type = PartType.get(typeName);
            if (type == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            return new GearPartIngredient(type);
        }

        public GearPartIngredient parse(JsonObject json) {
            String typeName = JSONUtils.func_151219_a((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            Object id = typeName.contains(":") ? new ResourceLocation(typeName) : SilentGear.getId(typeName);
            PartType type = PartType.get(id);
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            return new GearPartIngredient(type);
        }

        public void write(PacketBuffer buffer, GearPartIngredient ingredient) {
            buffer.func_192572_a(ingredient.type.getName());
        }
    }
}

