/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.HashSet;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.crafting.ingredient.ExclusionIngredient;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.lib.collection.StackList;

public class CombineFragmentsRecipe
extends SpecialRecipe {
    public CombineFragmentsRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.COMBINE_FRAGMENTS.get();
    }

    public boolean matches(CraftingInventory craftingInventory, World world) {
        int fragmentCount = 0;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            ItemStack stack = craftingInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ModItems.FRAGMENT.get()) {
                ++fragmentCount;
                continue;
            }
            return false;
        }
        if (fragmentCount != 8) {
            return false;
        }
        HashSet<ResourceLocation> uniques = new HashSet<ResourceLocation>();
        for (ItemStack stack : StackList.from((IInventory)craftingInventory)) {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            if (material == null) {
                return false;
            }
            uniques.add(material.getId());
        }
        return uniques.size() == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory craftingInventory) {
        StackList list = StackList.from((IInventory)craftingInventory);
        ItemStack stack = list.firstOfType(FragmentItem.class);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IMaterialInstance material = FragmentItem.getMaterial(stack);
        if (material == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack[] matchingStacks = material.getIngredient().func_193365_a();
        if (matchingStacks.length < 1) {
            ItemStack[] allMatches;
            if (material.getIngredient() instanceof ExclusionIngredient && (allMatches = ((ExclusionIngredient)material.getIngredient()).getMatchingStacksWithExclusions()).length > 0) {
                return allMatches[0];
            }
            return ItemStack.field_190927_a;
        }
        return matchingStacks[0].func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 8;
    }
}

