/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;

interface IGearRecipe {
    public ICoreItem getOutputItem();

    default public Collection<PartData> getParts(IInventory inv) {
        ArrayList<MaterialInstance> materials = new ArrayList<MaterialInstance>();
        ArrayList<PartData> parts = new ArrayList<PartData>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            MaterialInstance mat = MaterialInstance.from(stack);
            if (mat != null) {
                materials.add(mat);
                continue;
            }
            PartData part2 = PartData.from(stack);
            if (part2 == null) continue;
            parts.add(part2);
        }
        if (!materials.isEmpty()) {
            IGearRecipe.createToolHead(this.getOutputItem().getGearType(), materials).ifPresent(part -> parts.add(0, (PartData)part));
        }
        return parts;
    }

    public static Optional<PartData> createToolHead(GearType gearType, List<? extends IMaterialInstance> materials) {
        return IGearRecipe.createCompoundPart(gearType, PartType.MAIN, materials);
    }

    public static Optional<PartData> createCompoundPart(GearType gearType, PartType partType, List<? extends IMaterialInstance> materials) {
        return partType.getCompoundPartItem(gearType).map(item -> {
            ItemStack stack = item.create(materials);
            return PartData.from(stack);
        });
    }
}

