/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.salvage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.FragmentItem;

public class SalvagingRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation recipeId;
    protected Ingredient ingredient;
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public SalvagingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemStack> getPossibleResults(IInventory inv) {
        return new ArrayList<ItemStack>(this.results);
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    @Deprecated
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return !this.results.isEmpty() ? this.results.get(0) : ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.SALVAGING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.SALVAGING_TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static List<ItemStack> salvage(PartData part) {
        if (part.get() instanceof CompoundPart && part.getItem().func_77973_b() instanceof CompoundPartItem) {
            int craftedCount = ((CompoundPartItem)part.getItem().func_77973_b()).getCraftedCount(part.getItem());
            if (craftedCount < 1) {
                SilentGear.LOGGER.warn("Compound part's crafted count is less than 1? {}", (Object)part.getItem());
                return Collections.singletonList(part.getItem());
            }
            MaterialList materials = part.getMaterials();
            LinkedHashMap fragments = new LinkedHashMap();
            for (IMaterialInstance material : materials) {
                int fragmentCount = 8 / craftedCount;
                fragments.merge(material.get(), fragmentCount, Integer::sum);
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            for (Map.Entry entry : fragments.entrySet()) {
                ItemStack[] stacks;
                IMaterial material = (IMaterial)entry.getKey();
                int count = (Integer)entry.getValue();
                int fulls = count / 8;
                int frags = count % 8;
                if (fulls > 0 && (stacks = material.getIngredient().func_193365_a()).length > 0) {
                    ret.add(new ItemStack((IItemProvider)stacks[0].func_77973_b(), fulls));
                }
                if (frags <= 0) continue;
                ret.add(((FragmentItem)ModItems.FRAGMENT.get()).create(material, frags));
            }
            return ret;
        }
        return Collections.singletonList(part.getItem());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SalvagingRecipe> {
        public SalvagingRecipe read(ResourceLocation recipeId, JsonObject json) {
            SalvagingRecipe recipe = new SalvagingRecipe(recipeId);
            recipe.ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            JsonArray resultsArray = json.getAsJsonArray("results");
            for (JsonElement element : resultsArray) {
                if (element.isJsonObject()) {
                    Item item = JSONUtils.func_188180_i((JsonObject)element.getAsJsonObject(), (String)"item");
                    int count = JSONUtils.func_151208_a((JsonObject)element.getAsJsonObject(), (String)"count", (int)1);
                    recipe.results.add(new ItemStack((IItemProvider)item, count));
                    continue;
                }
                recipe.results.add(new ItemStack((IItemProvider)JSONUtils.func_188172_b((JsonElement)element, (String)"item")));
            }
            return recipe;
        }

        @Nullable
        public SalvagingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            SalvagingRecipe recipe = new SalvagingRecipe(recipeId);
            recipe.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int resultCount = buffer.readByte();
            for (int i = 0; i < resultCount; ++i) {
                recipe.results.add(buffer.func_150791_c());
            }
            return recipe;
        }

        public void write(PacketBuffer buffer, SalvagingRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.writeByte(recipe.results.size());
            recipe.results.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
        }
    }
}

