/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.data.trait.TraitBuilder;
import net.silentchaos512.gear.gear.trait.BlockFillerTrait;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.lib.util.NameUtils;

public class BlockFillerTraitBuilder
extends TraitBuilder {
    @Nullable
    private Block targetBlock;
    @Nullable
    private ITag.INamedTag<Block> targetBlockTag;
    private final Block fillBlock;
    private boolean replaceTileEntities = false;
    private int fillRangeX = 0;
    private int fillRangeY = 0;
    private int fillRangeZ = 0;
    private boolean fillFacingPlaneOnly = false;
    private BlockFillerTrait.SneakMode sneakMode = BlockFillerTrait.SneakMode.PASS;
    private final float damageOnUse;
    private int cooldown;
    private SoundEvent sound;
    private float soundVolume = 1.0f;
    private float soundPitch = 1.0f;

    public BlockFillerTraitBuilder(DataResource<ITrait> trait, int maxLevel, Block fillBlock, float damageOnUse) {
        this(trait.getId(), maxLevel, fillBlock, damageOnUse);
    }

    public BlockFillerTraitBuilder(ResourceLocation traitId, int maxLevel, Block fillBlock, float damageOnUse) {
        super(traitId, maxLevel, BlockFillerTrait.SERIALIZER);
        this.fillBlock = fillBlock;
        this.damageOnUse = damageOnUse;
        this.sound = this.fillBlock.func_176223_P().func_215695_r().func_185845_c();
    }

    public BlockFillerTraitBuilder target(ITag.INamedTag<Block> tag) {
        this.targetBlockTag = tag;
        return this;
    }

    public BlockFillerTraitBuilder target(Block block) {
        this.targetBlock = block;
        return this;
    }

    public BlockFillerTraitBuilder replaceTileEntities(boolean value) {
        this.replaceTileEntities = value;
        return this;
    }

    public BlockFillerTraitBuilder fillRange(int x, int y, int z, boolean fillFacingPlaneOnly) {
        this.fillRangeX = x;
        this.fillRangeY = y;
        this.fillRangeZ = z;
        this.fillFacingPlaneOnly = fillFacingPlaneOnly;
        return this;
    }

    public BlockFillerTraitBuilder sneakMode(BlockFillerTrait.SneakMode mode) {
        this.sneakMode = mode;
        return this;
    }

    public BlockFillerTraitBuilder cooldown(int timeInTicks) {
        this.cooldown = timeInTicks;
        return this;
    }

    public BlockFillerTraitBuilder sound(SoundEvent sound, float volume, float pitch) {
        this.sound = sound;
        this.soundVolume = volume;
        this.soundPitch = pitch;
        return this;
    }

    public BlockFillerTraitBuilder sound(float volume, float pitch) {
        this.soundVolume = volume;
        this.soundPitch = pitch;
        return this;
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = super.serialize();
        JsonObject targetJson = new JsonObject();
        if (this.targetBlockTag != null) {
            targetJson.addProperty("tag", this.targetBlockTag.func_230234_a_().toString());
        }
        if (this.targetBlock != null) {
            targetJson.addProperty("block", NameUtils.from((IForgeRegistryEntry)this.targetBlock).toString());
        }
        json.add("target", (JsonElement)targetJson);
        json.addProperty("fill_block", NameUtils.from((IForgeRegistryEntry)this.fillBlock).toString());
        json.addProperty("replace_tile_entities", Boolean.valueOf(this.replaceTileEntities));
        json.addProperty("fill_spread_x", (Number)this.fillRangeX);
        json.addProperty("fill_spread_y", (Number)this.fillRangeY);
        json.addProperty("fill_spread_z", (Number)this.fillRangeZ);
        json.addProperty("fill_facing_plane_only", Boolean.valueOf(this.fillFacingPlaneOnly));
        json.addProperty("sneak_mode", this.sneakMode.name().toLowerCase(Locale.ROOT));
        json.addProperty("damage_on_use", (Number)Float.valueOf(this.damageOnUse));
        json.addProperty("cooldown", (Number)this.cooldown);
        json.addProperty("sound", NameUtils.from((IForgeRegistryEntry)this.sound).toString());
        json.addProperty("sound_volume", (Number)Float.valueOf(this.soundVolume));
        json.addProperty("sound_pitch", (Number)Float.valueOf(this.soundPitch));
        return json;
    }
}

