/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;

public class CraftedMaterialItem
extends Item
implements IColoredMaterialItem {
    private static final String NBT_MATERIAL = "Material";

    public CraftedMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static IMaterialInstance getMaterial(ItemStack stack) {
        String id;
        IMaterial mat;
        INBT nbt = stack.func_196082_o().func_74781_a(NBT_MATERIAL);
        if (nbt instanceof CompoundNBT) {
            MaterialInstance mat2 = MaterialInstance.read((CompoundNBT)nbt);
            if (mat2 != null) {
                return mat2;
            }
        } else if (nbt != null && (mat = MaterialManager.get(SilentGear.getIdWithDefaultNamespace(id = nbt.func_150285_a_()))) != null) {
            return MaterialInstance.of(mat);
        }
        return LazyMaterialInstance.of(Const.Materials.EXAMPLE);
    }

    public ItemStack create(IMaterialInstance material, int count) {
        ItemStack result = new ItemStack((IItemProvider)this, count);
        result.func_196082_o().func_218657_a(NBT_MATERIAL, (INBT)material.write(new CompoundNBT()));
        return result;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        IMaterialInstance material = CraftedMaterialItem.getMaterial(stack);
        IMaterialDisplay model = MaterialDisplayManager.get(material);
        return model.getLayerColor(GearType.ALL, PartType.MAIN, material, layer);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IMaterialInstance material = CraftedMaterialItem.getMaterial(stack);
        return new TranslationTextComponent(this.func_77658_a(), new Object[]{material.getDisplayName(PartType.MAIN)});
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.create(LazyMaterialInstance.of(Const.Materials.EXAMPLE), 1));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_196082_o().func_74781_a(NBT_MATERIAL) instanceof StringNBT) {
            tooltip.add((ITextComponent)new StringTextComponent("Has an older NBT format").func_240699_a_(TextFormatting.RED));
            tooltip.add((ITextComponent)new StringTextComponent("May not stack with newer items").func_240699_a_(TextFormatting.RED));
        }
    }
}

