/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.TextUtil;

public class FragmentItem
extends Item {
    private static final String NBT_MATERIAL = "Material";

    public FragmentItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack create(IMaterial material, int count) {
        ItemStack stack = new ItemStack((IItemProvider)this, count);
        stack.func_196082_o().func_74778_a(NBT_MATERIAL, SilentGear.shortenId(material.getId()));
        return stack;
    }

    @Nullable
    public static IMaterialInstance getMaterial(ItemStack stack) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)stack.func_196082_o().func_74779_i(NBT_MATERIAL));
        IMaterial material = MaterialManager.get(id);
        if (material != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    public static String getModelKey(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_MATERIAL);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IMaterialInstance material = FragmentItem.getMaterial(stack);
        if (material == null) {
            return new TranslationTextComponent(this.func_77667_c(stack) + ".invalid");
        }
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[]{material.getDisplayName(PartType.MAIN)});
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        items.add((Object)new ItemStack((IItemProvider)this));
        if (SilentGear.isDevBuild()) {
            for (IMaterial material : MaterialManager.getValues()) {
                items.add((Object)this.create(material, 1));
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TextUtil.translate("item", "fragment.hint").func_240699_a_(TextFormatting.ITALIC));
    }
}

