/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.ModelErrorLogging;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class CoreArmor
extends DyeableArmorItem
implements ICoreArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final float[] ABSORPTION_RATIO_BY_SLOT = new float[]{0.15f, 0.3f, 0.4f, 0.15f};
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private static final Cache<String, Integer> ARMOR_COLORS = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public CoreArmor(EquipmentSlotType slot) {
        super((IArmorMaterial)ArmorMaterial.DIAMOND, slot, GearHelper.getBuilder(null));
    }

    @Deprecated
    public CoreArmor(EquipmentSlotType slot, String name) {
        this(slot);
    }

    @Override
    public GearType getGearType() {
        switch (this.func_185083_B_()) {
            case HEAD: {
                return GearType.HELMET;
            }
            case CHEST: {
                return GearType.CHESTPLATE;
            }
            case LEGS: {
                return GearType.LEGGINGS;
            }
            case FEET: {
                return GearType.BOOTS;
            }
        }
        throw new IllegalStateException("Don't know the gear type for " + this.getRegistryName());
    }

    @Override
    public boolean isValidSlot(String slot) {
        return this.func_185083_B_().func_188450_d().equalsIgnoreCase(slot);
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return MAX_DAMAGE_ARRAY[this.func_185083_B_().func_188454_b()];
    }

    public double getArmorProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, ItemStats.ARMOR);
    }

    public double getArmorToughness(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, ItemStats.ARMOR_TOUGHNESS);
    }

    public double getArmorMagicProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0;
        }
        return GearData.getStat(stack, ItemStats.MAGIC_ARMOR);
    }

    private static double getGenericArmorProtection(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof CoreArmor) {
            return ((CoreArmor)item).getArmorProtection(stack);
        }
        if (item instanceof ArmorItem) {
            return ((ArmorItem)item).func_200881_e();
        }
        return 0.0;
    }

    private static int getPlayerTotalArmorValue(LivingEntity player) {
        float total = 0.0f;
        for (ItemStack armor : player.func_184193_aE()) {
            total = (float)((double)total + CoreArmor.getGenericArmorProtection(armor));
        }
        return Math.round(total);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        if (slot == this.func_185083_B_()) {
            UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
            multimap.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Armor modifier", this.getArmorProtection(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "Armor toughness", this.getArmorToughness(stack), AttributeModifier.Operation.ADDITION));
            float knockbackResistance = GearData.getStat(stack, ItemStats.KNOCKBACK_RESISTANCE) / 10.0f;
            if (knockbackResistance > 0.0f) {
                multimap.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)knockbackResistance, AttributeModifier.Operation.ADDITION));
            }
            return GearHelper.getAttributeModifiers(slot, stack, (Multimap<Attribute, AttributeModifier>)multimap);
        }
        return multimap;
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamageFactor = GearData.getStatInt(stack, this.getDurabilityStat());
        return MAX_DAMAGE_ARRAY[this.func_185083_B_().func_188454_b()] * maxDamageFactor;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = MathHelper.func_76125_a((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, t -> {
            GearHelper.onBroken(stack, t instanceof PlayerEntity ? (PlayerEntity)t : null, this.func_185083_B_());
            onBroken.accept(t);
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.ENCHANTABILITY);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        GearHelper.inventoryTick(stack, world, (Entity)player, 0, true);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        int layer;
        if (GearHelper.isBroken(stack)) {
            return "silentgear:textures/models/armor/empty.png";
        }
        int n = layer = slot == EquipmentSlotType.LEGS ? 2 : 1;
        if ("overlay".equals(type)) {
            return "silentgear:textures/models/armor/all_layer_" + layer + "_overlay.png";
        }
        MaterialInstance material = GearData.getPrimaryArmorMaterial(stack);
        if (material != null) {
            IMaterialDisplay materialModel = MaterialDisplayManager.get(material);
            PartType partType = GearData.hasPartOfType(stack, PartType.COATING) ? PartType.COATING : PartType.MAIN;
            MaterialLayer materialLayer = materialModel.getLayerList(this.getGearType(), partType, (IMaterialInstance)material).getFirstLayer();
            if (materialLayer != null) {
                ResourceLocation tex = materialLayer.getTextureId();
                return tex.func_110624_b() + ":textures/models/armor/" + tex.func_110623_a() + "_layer_" + layer + (type != null ? "_" + type : "") + ".png";
            }
        }
        return "silentgear:textures/models/armor/main_generic_hc_layer_" + layer + (type != null ? "_" + type : "") + ".png";
    }

    public boolean func_200883_f_(ItemStack stack) {
        return true;
    }

    public int func_200886_f(ItemStack stack) {
        try {
            return (Integer)ARMOR_COLORS.get((Object)GearData.getModelKey(stack, 0), () -> CoreArmor.getArmorColor(stack));
        }
        catch (ExecutionException e) {
            ModelErrorLogging.notifyOfException(e, "armor model");
            return 0xFFFFFF;
        }
    }

    private static int getArmorColor(ItemStack stack) {
        PartData part = GearData.getCoatingOrMainPart(stack);
        if (part != null) {
            return part.getColor(stack);
        }
        return 0xFFFFFF;
    }

    public void func_200884_g(ItemStack stack) {
    }

    public void func_200885_a(ItemStack stack, int color) {
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }
}

