/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreShears
extends ShearsItem
implements ICoreTool {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ENCHANTABILITY, (Object)ItemStats.HARVEST_SPEED);

    public CoreShears() {
        super(GearHelper.getBuilder(null).func_200918_c(100));
    }

    @Override
    public GearType getGearType() {
        return GearType.SHEARS;
    }

    @Override
    public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        float speed = this.getStat(stack, ItemStats.HARVEST_SPEED);
        if (!state.func_203425_a(Blocks.field_196553_aF) && !state.func_235714_a_((ITag)BlockTags.field_206952_E)) {
            return state.func_235714_a_((ITag)BlockTags.field_199897_a) ? speed - 1.0f : 1.0f;
        }
        return 2.5f * speed;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
        if (GearHelper.isBroken(stack)) {
            return ActionResultType.PASS;
        }
        return super.func_111207_a(stack, playerIn, entity, hand);
    }

    @Override
    public int getDamageOnBlockBreak(ItemStack gear, World world, BlockState state, BlockPos pos) {
        if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_232872_am_)) {
            return 1;
        }
        return ICoreTool.super.getDamageOnBlockBreak(gear, world, state, pos);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.ENCHANTABILITY);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, GearHelper.calcDamageClamped(stack, damage));
        if (GearHelper.isBroken(stack)) {
            GearData.recalculateStats(stack, null);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (player != null && CoreShears.getHoneyLevel(state) >= 5) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            BeehiveBlock.func_226878_a_((World)world, (BlockPos)pos);
            context.func_195996_i().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
            BeehiveBlock block = (BeehiveBlock)state.func_177230_c();
            if (!CampfireBlock.func_235474_a_((World)world, (BlockPos)pos)) {
                if (block.func_226882_d_(world, pos)) {
                    block.func_226881_b_(world, pos);
                }
                block.func_226877_a_(world, state, pos, player, BeehiveTileEntity.State.EMERGENCY);
            } else {
                block.func_226876_a_(world, state, pos);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return GearHelper.onItemUse(context);
    }

    private static int getHoneyLevel(BlockState state) {
        if (state.func_177230_c() instanceof BeehiveBlock && state.func_235901_b_((Property)BeehiveBlock.field_226873_c_)) {
            return (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_);
        }
        return 0;
    }
}

