/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.util.GearData;

public final class GearGenerator {
    private GearGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static Optional<PartData> getRandomPart(GearType gearType, PartType type) {
        return GearGenerator.getRandomPart(gearType, type, -1);
    }

    public static Optional<PartData> getRandomPart(GearType gearType, PartType partType, int partTier) {
        Optional<PartData> optional = partType.getCompoundPartItem(gearType).map(item -> PartManager.from(new ItemStack((IItemProvider)item))).map(part -> part.randomizeData(gearType, partTier));
        if (!optional.isPresent()) {
            List partsOfTier = PartManager.getValues().stream().filter(part -> partTier == -1 || partTier == part.getTier()).collect(Collectors.toList());
            if (!partsOfTier.isEmpty()) {
                IGearPart random = (IGearPart)partsOfTier.get(SilentGear.RANDOM.nextInt(partsOfTier.size()));
                return Optional.of(random.randomizeData(gearType, partTier));
            }
            if (partTier != -1) {
                return GearGenerator.getRandomPart(gearType, partType, -1);
            }
            return Optional.empty();
        }
        return optional;
    }

    public static ItemStack create(ICoreItem item, int minTier, int maxTier) {
        if (minTier >= maxTier) {
            return GearGenerator.create(item, maxTier);
        }
        return GearGenerator.create(item, minTier + SilentGear.RANDOM.nextInt(maxTier - minTier));
    }

    public static ItemStack create(ICoreItem item, int tier) {
        return GearGenerator.randomizeParts(new ItemStack((IItemProvider)item), tier);
    }

    public static ItemStack randomizeParts(ItemStack stack, int tier) {
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            throw new RuntimeException("Called GearGenerator.randomizeParts on non-gear");
        }
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        GearType gearType = item.getGearType();
        PartDataList parts = PartDataList.of(new PartData[0]);
        for (PartType partType : item.getRequiredParts()) {
            GearGenerator.getRandomPart(gearType, partType, tier).ifPresent(parts::add);
        }
        if (parts.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = stack.func_77946_l();
        parts.forEach(p -> p.onAddToGear(result));
        GearData.writeConstructionParts(result, parts);
        if (item instanceof ICoreTool && tier > 1 && SilentGear.RANDOM.nextFloat() < 0.2f * (float)tier + 0.1f) {
            GearGenerator.getRandomPart(gearType, PartType.TIP, tier).ifPresent(part -> GearData.addUpgradePart(result, part));
        }
        GearData.recalculateStats(result, null);
        return result;
    }
}

