/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.gear.trait.SynergyTrait;
import net.silentchaos512.gear.util.TextUtil;

public final class SynergyUtils {
    private static final double SYNERGY_MULTI = 1.1;
    private static final double MIN_VALUE = 0.1;
    public static final double MAX_VALUE = 2.0;

    private SynergyUtils() {
    }

    public static float getSynergy(PartType partType, List<? extends IMaterialInstance> materials, Collection<TraitInstance> traits) {
        if (materials.isEmpty()) {
            return 1.0f;
        }
        double synergy = SynergyUtils.getBaseSynergy(materials);
        IMaterialInstance primary = materials.get(0);
        double primaryRarity = primary.getStat(partType, ItemStats.RARITY);
        double maxRarity = materials.stream().mapToDouble(m -> m.getStat(partType, ItemStats.RARITY)).max().orElse(0.0);
        int maxTier = materials.stream().mapToInt(m -> m.getTier(partType)).max().orElse(0);
        for (IMaterialInstance material : SynergyUtils.getUniques(materials)) {
            if (maxRarity > 0.0) {
                float rarity = material.getStat(partType, ItemStats.RARITY);
                synergy -= 0.005 * Math.abs(primaryRarity - (double)rarity);
            }
            if (maxTier <= 0) continue;
            int tier = material.getTier(partType);
            synergy -= 0.08 * (double)Math.abs(maxTier - tier);
        }
        for (TraitInstance trait : traits) {
            if (!(trait.getTrait() instanceof SynergyTrait)) continue;
            synergy = ((SynergyTrait)trait.getTrait()).apply(synergy, trait.getLevel());
        }
        return (float)MathHelper.func_151237_a((double)synergy, (double)0.1, (double)2.0);
    }

    public static Collection<IMaterialInstance> getUniques(Collection<? extends IMaterialInstance> materials) {
        LinkedHashMap<ResourceLocation, IMaterialInstance> ret = new LinkedHashMap<ResourceLocation, IMaterialInstance>();
        for (IMaterialInstance iMaterialInstance : materials) {
            ret.put(iMaterialInstance.getId(), iMaterialInstance);
        }
        return ret.values();
    }

    public static ITextComponent getDisplayText(float synergy) {
        TextFormatting color = synergy < 1.0f ? TextFormatting.RED : (synergy > 1.0f ? TextFormatting.GREEN : TextFormatting.WHITE);
        IFormattableTextComponent value = new StringTextComponent(Math.round(100.0f * synergy) + "%").func_240699_a_(color);
        return TextUtil.translate("misc", "synergy", value);
    }

    private static double getBaseSynergy(Collection<? extends IMaterialInstance> materials) {
        int x = SynergyUtils.getUniqueCount(materials);
        double a = 1.1;
        return 1.1 * ((double)x / ((double)x + 1.1)) + 0.47619047619047616;
    }

    private static int getUniqueCount(Collection<? extends IMaterialInstance> materials) {
        return materials.stream().map(IGearComponentInstance::getId).collect(Collectors.toSet()).size();
    }
}

