/*
 * Decompiled with CFR 0.152.
 */
package eu.tsp.evilwanderingtrader.common.entities;

import com.google.common.collect.ImmutableList;
import eu.tsp.evilwanderingtrader.EvilWanderingTrader;
import eu.tsp.evilwanderingtrader.common.entities.ThiefLlamaEntity;
import eu.tsp.evilwanderingtrader.common.entities.ThiefWanderingTraderEntity;
import eu.tsp.evilwanderingtrader.common.goals.ThiefAttackGoal;
import eu.tsp.evilwanderingtrader.common.goals.ThiefAttackableTargetGoal;
import eu.tsp.evilwanderingtrader.init.ModEntityTypes;
import eu.tsp.evilwanderingtrader.init.ModSoundEventTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ThiefEntity
extends MonsterEntity
implements IMob {
    public static final Double MAX_DISTANCE_TO_LLAMAS = 16.0;
    @Nullable
    PlayerEntity nemesis;
    @Nullable
    UUID nemesisUUID;
    int ticksBeforeReconversion = -1;
    boolean converting = false;
    int pickedUpEmerald = 0;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public ThiefEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = 100;
        this.nemesis = null;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233825_h_, 0.8).func_233815_a_(Attributes.field_233820_c_, 0.7).func_233815_a_(Attributes.field_233819_b_, 80.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_110163_bv();
        if (reason == SpawnReason.CONVERSION) {
            EvilWanderingTrader.debugMessage(worldIn.func_201672_e(), "Converted trader to Thief");
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, new ThiefAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, entity -> entity instanceof PlayerEntity && entity.equals(this.nemesis)));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (Goal)new ThiefAttackGoal(this, 1.35, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 16.0f, 0.05f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!super.func_70652_k(entityIn)) {
            return false;
        }
        if (!(entityIn instanceof PlayerEntity) || !entityIn.equals((Object)this.nemesis)) {
            return false;
        }
        PlayerInventory inv = this.nemesis.field_71071_by;
        ImmutableList allInventories = ImmutableList.of((Object)inv.field_70462_a, (Object)inv.field_70460_b, (Object)inv.field_184439_c);
        int itemCount = 0;
        for (List list : allInventories) {
            for (ItemStack itemStack : list) {
                if (itemStack.func_190926_b()) continue;
                ++itemCount;
            }
        }
        if (itemCount <= 0) {
            this.setDone();
        } else {
            int choice = new Random().nextInt(itemCount);
            itemCount = -1;
            for (List list : allInventories) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((ItemStack)list.get(i)).func_190926_b() || ++itemCount != choice) continue;
                    ItemStack stack = (ItemStack)list.get(i);
                    EvilWanderingTrader.debugMessage((ServerWorld)this.field_70170_p, (ITextComponent)new StringTextComponent(String.format("Stole %d ", stack.func_190916_E())).func_230529_a_(stack.func_77973_b().func_200295_i(stack)));
                    this.sendStolenItemStack(stack);
                    list.set(i, ItemStack.field_190927_a);
                }
            }
        }
        return true;
    }

    protected void sendStolenItemStack(ItemStack items) {
        Double maxDistance = MAX_DISTANCE_TO_LLAMAS;
        List entities = this.field_70170_p.func_217357_a(ThiefLlamaEntity.class, new AxisAlignedBB(this.func_226277_ct_() - maxDistance, this.func_226280_cw_() - maxDistance / 2.0, this.func_226281_cx_() - maxDistance, this.func_226277_ct_() + maxDistance, this.func_226280_cw_() + maxDistance / 2.0, this.func_226281_cx_() + maxDistance));
        if (!entities.isEmpty()) {
            Iterator llamas = entities.iterator();
            ThiefLlamaEntity llama = (ThiefLlamaEntity)((Object)llamas.next());
            Predicate<ThiefLlamaEntity> a = ll -> ll.func_70089_S() && ll.thief != null && ll.thief.equals((Object)this) && ll.addToChest(items);
            boolean success = a.test(llama);
            while (!success && llamas.hasNext()) {
                llama = (ThiefLlamaEntity)((Object)llamas.next());
                success = a.test(llama);
            }
            if (success) {
                return;
            }
        }
        this.nemesis.func_146097_a(items, true, false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.nemesis != null) {
            compound.func_186854_a("NemesisUUID", this.nemesis.func_110124_au());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("NemesisUUID")) {
            this.nemesisUUID = compound.func_186857_a("NemesisUUID");
        }
    }

    public void setNemesis(PlayerEntity player) {
        this.nemesis = player;
        this.bossInfo.func_186760_a((ServerPlayerEntity)player);
    }

    public boolean isDone() {
        if (this.func_70643_av() instanceof PlayerEntity) {
            this.setNemesis((PlayerEntity)this.func_70643_av());
            this.func_213395_q(true);
            this.ticksBeforeReconversion = -1;
        }
        return this.ticksBeforeReconversion >= 0;
    }

    public void setDone() {
        if (!this.isDone()) {
            EvilWanderingTrader.debugMessage((ServerWorld)this.field_70170_p, "Done");
            this.func_213395_q(false);
            this.ticksBeforeReconversion = 300;
            this.nemesis = null;
        }
    }

    public boolean isConverting() {
        return this.converting;
    }

    public void setConverting(boolean converting) {
        this.converting = converting;
    }

    public void turnBackIntoWanderer() {
        if (!this.field_70170_p.field_72995_K && !this.isConverting() && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModEntityTypes.THIEF_WANDERING_TRADER.get()), timer -> {
            this.ticksBeforeReconversion = timer;
        })) {
            this.setConverting(true);
            ThiefWanderingTraderEntity wanderer = this.startConversion((ServerWorld)this.field_70170_p);
            Double maxDistance = MAX_DISTANCE_TO_LLAMAS;
            List entities = this.field_70170_p.func_217357_a(ThiefLlamaEntity.class, new AxisAlignedBB(this.func_226277_ct_() - maxDistance, this.func_226280_cw_() - maxDistance / 2.0, this.func_226281_cx_() - maxDistance, this.func_226277_ct_() + maxDistance, this.func_226280_cw_() + maxDistance / 2.0, this.func_226281_cx_() + maxDistance));
            if (!entities.isEmpty()) {
                for (ThiefLlamaEntity llama : entities) {
                    if (!llama.func_70089_S() || llama.thief == null || !llama.thief.equals((Object)this)) continue;
                    llama.turnBackIntoWandererLlama(wanderer);
                }
            }
        }
    }

    private ThiefWanderingTraderEntity startConversion(ServerWorld serverWorld) {
        ThiefWanderingTraderEntity wanderer = (ThiefWanderingTraderEntity)this.func_233656_b_((EntityType)ModEntityTypes.THIEF_WANDERING_TRADER.get(), false);
        wanderer.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(wanderer.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 60, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.func_184185_a((SoundEvent)ModSoundEventTypes.THIEF_CONVERSION.get(), 0.5f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 1.0f);
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197625_r, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 2, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)wanderer);
        return wanderer;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70089_S() && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0))) {
                if (!itementity.func_70089_S() || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                if (itementity.func_92059_d().func_77973_b() == Items.field_151166_bC) {
                    this.pickedUpEmerald += itementity.func_92059_d().func_190916_E();
                    itementity.func_70106_y();
                }
                if (this.pickedUpEmerald < 5) continue;
                this.setDone();
                break;
            }
        }
    }

    public void func_70071_h_() {
        PlayerEntity player;
        if (!this.field_70170_p.field_72995_K && this.nemesisUUID != null && (player = this.field_70170_p.func_217371_b(this.nemesisUUID)) != null) {
            this.nemesis = player;
            this.nemesisUUID = null;
        }
        if (this.ticksBeforeReconversion > 0) {
            --this.ticksBeforeReconversion;
        }
        if (this.ticksBeforeReconversion == 0) {
            this.turnBackIntoWanderer();
        }
        if (this.nemesis != null && !this.nemesis.func_70089_S()) {
            this.setDone();
        }
        if (this.nemesis != null && this.nemesis.func_70068_e((Entity)this) > 200.0) {
            this.setDone();
        }
        super.func_70071_h_();
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEventTypes.THIEF_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEventTypes.THIEF_DEATH.get();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEventTypes.THIEF_AMBIENT.get();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

