/*
 * Decompiled with CFR 0.152.
 */
package eu.tsp.evilwanderingtrader.common.entities;

import eu.tsp.evilwanderingtrader.EvilWanderingTrader;
import eu.tsp.evilwanderingtrader.common.entities.ThiefTraderLlamaEntity;
import eu.tsp.evilwanderingtrader.common.entities.ThiefWanderingTraderEntity;
import eu.tsp.evilwanderingtrader.common.goals.FollowEntityGoal;
import eu.tsp.evilwanderingtrader.init.ModEntityTypes;
import eu.tsp.evilwanderingtrader.init.ModSoundEventTypes;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ThiefLlamaEntity
extends LlamaEntity
implements IMob,
IRangedAttackMob {
    @Nullable
    PlayerEntity nemesis;
    boolean field_190723_bJ = false;
    Entity thief;
    private Goal escape = null;

    public ThiefLlamaEntity(EntityType<? extends LlamaEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110207_m(true);
        this.func_110226_cD();
        this.nemesis = null;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 16.0).func_233815_a_(Attributes.field_233825_h_, 0.1).func_233815_a_(Attributes.field_233820_c_, 0.7);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.CONVERSION) {
            EvilWanderingTrader.debugMessage(worldIn.func_201672_e(), "Converted llama to LlamaThief");
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.escape = new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, (double)1.2f, (double)1.8f);
        this.field_70715_bh.func_75776_a(1, (Goal)new FollowEntityGoal((MobEntity)this, 1.0, 4.0f, 16.0f, entity -> entity.equals((Object)this.thief)));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 40, 20.0f));
        this.field_70714_bg.func_75776_a(2, this.escape);
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 32.0f, 0.1f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    public void setNemesis(PlayerEntity player) {
        this.nemesis = player;
    }

    public PlayerEntity getNemesis() {
        return this.nemesis;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity) {
            ItemStack bones = new ItemStack((IItemProvider)Items.field_151103_aS, this.field_70146_Z.nextInt(6));
            this.func_199701_a_(bones);
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (target.equals((Object)this.nemesis)) {
            this.spit(target);
        }
    }

    private void spit(LivingEntity target) {
        LlamaSpitEntity llamaspitentity = new LlamaSpitEntity(this.field_70170_p, (LlamaEntity)this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - llamaspitentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        llamaspitentity.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 10.0f);
        if (!this.func_174814_R()) {
            this.func_184185_a(SoundEvents.field_191255_dF, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        this.field_70170_p.func_217376_c((Entity)llamaspitentity);
        this.field_190723_bJ = true;
    }

    public void setInventory(Inventory inventory) {
        if (inventory.func_70302_i_() <= this.func_190686_di()) {
            this.field_110296_bG = inventory;
        }
    }

    protected int func_190686_di() {
        return 17;
    }

    public int func_190696_dl() {
        return 5;
    }

    public int chestFirstFreeSlot() {
        int i;
        Inventory inv = this.field_110296_bG;
        for (i = 2; i < inv.func_70302_i_() && !inv.func_70301_a(i).func_190926_b(); ++i) {
        }
        return i;
    }

    public boolean addToChest(ItemStack items) {
        int i = this.chestFirstFreeSlot();
        if (i == this.field_110296_bG.func_70302_i_()) {
            return false;
        }
        this.field_110296_bG.func_70299_a(i, items);
        return true;
    }

    protected void func_213337_cE() {
        this.func_110207_m(false);
        super.func_213337_cE();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.thief != null) {
            compound.func_74768_a("ThiefUUID", this.thief.func_145782_y());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ThiefUUID")) {
            this.thief = this.field_70170_p.func_73045_a(compound.func_74762_e("ThiefUUID"));
        }
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEventTypes.THIEF_LLAMA_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191254_dE;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191252_dC;
    }

    protected SoundEvent func_184785_dv() {
        return SoundEvents.field_191250_dA;
    }

    public boolean func_190684_dE() {
        return false;
    }

    public void turnBackIntoWandererLlama(ThiefWanderingTraderEntity trader) {
        if (!this.field_70170_p.field_72995_K) {
            this.startConversion((ServerWorld)this.field_70170_p, trader);
        }
    }

    private void startConversion(ServerWorld serverWorld, ThiefWanderingTraderEntity trader) {
        ThiefTraderLlamaEntity llama = (ThiefTraderLlamaEntity)this.func_233656_b_((EntityType)ModEntityTypes.THIEF_TRADER_LLAMA.get(), false);
        llama.setInventory(this.field_110296_bG);
        llama.func_184779_b(this.func_184780_dh());
        llama.func_110234_j(this.func_110248_bS());
        llama.func_110162_b((Entity)trader, true);
        llama.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(llama.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 60, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.func_184185_a((SoundEvent)ModSoundEventTypes.THIEF_CONVERSION.get(), 0.5f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 1.0f);
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197625_r, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 2, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)llama);
    }

    public boolean func_110263_g(PlayerEntity player) {
        if (this.escape != null) {
            this.field_70714_bg.func_85156_a(this.escape);
            this.escape = null;
        }
        return super.func_110263_g(player);
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

