/*
 * Decompiled with CFR 0.152.
 */
package eu.tsp.evilwanderingtrader.common.entities;

import eu.tsp.evilwanderingtrader.EvilWanderingTrader;
import eu.tsp.evilwanderingtrader.common.entities.ThiefEntity;
import eu.tsp.evilwanderingtrader.common.entities.ThiefLlamaEntity;
import eu.tsp.evilwanderingtrader.common.entities.ThiefWanderingTraderEntity;
import eu.tsp.evilwanderingtrader.common.goals.EvilLlamaWhenHitGoal;
import eu.tsp.evilwanderingtrader.init.ModEntityTypes;
import eu.tsp.evilwanderingtrader.init.ModSoundEventTypes;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.event.ForgeEventFactory;

public class ThiefTraderLlamaEntity
extends TraderLlamaEntity {
    public ThiefTraderLlamaEntity(EntityType<? extends ThiefTraderLlamaEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_110207_m(true);
        this.func_110226_cD();
        this.field_190688_bE = false;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.1).func_233815_a_(Attributes.field_233820_c_, 0.7);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (Goal)new FollowThiefTraderGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EvilLlamaWhenHitGoal(this));
    }

    @Nullable
    private static BlockPos llamaSpawnPos(BlockPos pos, ServerWorld world, int radius) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.func_177958_n() + world.func_201674_k().nextInt(radius * 2) - radius;
            BlockPos blockpos1 = new BlockPos(j, l = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, j, k = pos.func_177952_p() + world.func_201674_k().nextInt(radius * 2) - radius), k);
            if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)world, (BlockPos)blockpos1, (EntityType)((EntityType)ModEntityTypes.THIEF_TRADER_LLAMA.get()))) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    public static boolean spawnLlamas(ThiefWanderingTraderEntity trader, BlockPos pos, ServerWorld world, int count) {
        ThiefTraderLlamaEntity llama;
        if (count <= 0) {
            return false;
        }
        boolean success = false;
        BlockPos randPos = ThiefTraderLlamaEntity.llamaSpawnPos(pos, world, 2);
        if (randPos != null && (llama = (ThiefTraderLlamaEntity)((EntityType)ModEntityTypes.THIEF_TRADER_LLAMA.get()).func_220342_a(world, null, null, null, randPos, SpawnReason.EVENT, false, false)) != null) {
            llama.func_110162_b((Entity)trader, true);
            success = true;
        }
        return success | ThiefTraderLlamaEntity.spawnLlamas(trader, pos, world, count - 1);
    }

    @Nullable
    public MerchantOffer getMerchantOfferFromInventorySlot(int slot) {
        if (slot >= this.func_190686_di()) {
            return null;
        }
        ItemStack stack = this.field_110296_bG.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return null;
        }
        ItemStack price = new ItemStack((IItemProvider)Items.field_151166_bC, 5 + this.field_70146_Z.nextInt(5));
        return new MerchantOffer(price, stack, 1, 10, 1.0f);
    }

    public void removeItemStackFromInventory(ItemStack stack) {
        for (int i = 0; i < this.func_190686_di(); ++i) {
            if (!this.field_110296_bG.func_70301_a(i).equals(stack)) continue;
            this.field_110296_bG.func_70299_a(i, ItemStack.field_190927_a);
            if (this.field_70170_p.field_72995_K) break;
            EvilWanderingTrader.debugMessage((ServerWorld)this.field_70170_p, (ITextComponent)new StringTextComponent(String.format("Remove from lamas: %d ", stack.func_190916_E())).func_230529_a_(stack.func_77973_b().func_200295_i(stack)));
            break;
        }
    }

    protected int func_190686_di() {
        return 17;
    }

    public int func_190696_dl() {
        return 5;
    }

    protected void func_213337_cE() {
        this.func_110207_m(false);
        super.func_213337_cE();
    }

    public void setInventory(Inventory inventory) {
        if (inventory.func_70302_i_() <= this.func_190686_di()) {
            this.field_110296_bG = inventory;
        }
    }

    public void turnIntoThiefLlama(PlayerEntity player, ThiefEntity thief) {
        if (!this.field_70170_p.field_72995_K) {
            this.startConversion((ServerWorld)this.field_70170_p, player, thief);
        }
    }

    private void startConversion(ServerWorld serverWorld, PlayerEntity player, ThiefEntity thief) {
        ThiefLlamaEntity thiefLlama = (ThiefLlamaEntity)this.func_233656_b_((EntityType)ModEntityTypes.THIEF_LLAMA.get(), false);
        thiefLlama.setNemesis(player);
        thiefLlama.setInventory(this.field_110296_bG);
        thiefLlama.func_184779_b(this.func_184780_dh());
        thiefLlama.func_110234_j(this.func_110248_bS());
        thiefLlama.thief = thief;
        thiefLlama.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(thiefLlama.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 200, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.func_184185_a((SoundEvent)ModSoundEventTypes.THIEF_CONVERSION.get(), 2.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.2f + 0.3f);
        for (int i = 0; i < 60; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.2;
            double d1 = this.field_70146_Z.nextGaussian() * 0.2;
            double d2 = this.field_70146_Z.nextGaussian() * 0.2;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197616_i, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 1, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197626_s, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 1, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 1, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)thiefLlama);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        int i;
        Inventory inv = this.field_110296_bG;
        for (i = 2; i < inv.func_70302_i_() && inv.func_70301_a(i).func_190926_b(); ++i) {
        }
        return i == this.func_190686_di();
    }

    protected void func_110237_h(PlayerEntity player) {
        Entity entity = this.func_110166_bE();
        if (!(entity instanceof ThiefWanderingTraderEntity)) {
            super.func_110237_h(player);
        }
    }

    public class FollowThiefTraderGoal
    extends TargetGoal {
        private final ThiefTraderLlamaEntity llama;
        private LivingEntity target;
        private int revengeTimer;

        public FollowThiefTraderGoal(ThiefTraderLlamaEntity llama) {
            super((MobEntity)llama, false);
            this.llama = llama;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            if (!this.llama.func_110167_bD()) {
                return false;
            }
            Entity entity = this.llama.func_110166_bE();
            if (!(entity instanceof WanderingTraderEntity)) {
                return false;
            }
            WanderingTraderEntity wanderingtraderentity = (WanderingTraderEntity)entity;
            this.target = wanderingtraderentity.func_70643_av();
            int i = wanderingtraderentity.func_142015_aE();
            return i != this.revengeTimer && this.func_220777_a(this.target, EntityPredicate.field_221016_a);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.target);
            Entity entity = this.llama.func_110166_bE();
            if (entity instanceof WanderingTraderEntity) {
                this.revengeTimer = ((WanderingTraderEntity)entity).func_142015_aE();
            }
            super.func_75249_e();
        }
    }
}

