/*
 * Decompiled with CFR 0.152.
 */
package eu.tsp.evilwanderingtrader.common.entities;

import eu.tsp.evilwanderingtrader.EvilWanderingTrader;
import eu.tsp.evilwanderingtrader.common.entities.ThiefEntity;
import eu.tsp.evilwanderingtrader.common.entities.ThiefTraderLlamaEntity;
import eu.tsp.evilwanderingtrader.common.goals.EvilThiefWhenHitGoal;
import eu.tsp.evilwanderingtrader.init.ModEntityTypes;
import eu.tsp.evilwanderingtrader.init.ModSoundEventTypes;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ThiefWanderingTraderEntity
extends WanderingTraderEntity {
    private int lastSales = 0;
    @Nullable
    private PlayerEntity lastCustomer;
    private boolean spawnLlamas = true;

    public ThiefWanderingTraderEntity(EntityType<? extends ThiefWanderingTraderEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_213728_s(48000);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.CONVERSION) {
            this.spawnLlamas = false;
            EvilWanderingTrader.debugMessage(worldIn.func_201672_e(), "Converted back to Wandering Trader");
        } else if (reason != SpawnReason.NATURAL && reason != SpawnReason.CHUNK_GENERATION) {
            EvilWanderingTrader.debugMessage(worldIn.func_201672_e(), "Spawned Thief Wandering Trader");
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213704_a(MerchantOffer offer) {
        super.func_213704_a(offer);
        ++this.lastSales;
        this.forTraderLlamas(llama -> llama.removeItemStackFromInventory(offer.func_222200_d()));
    }

    public void func_70636_d() {
        if (this.spawnLlamas && !this.field_70170_p.field_72995_K) {
            boolean bl = this.spawnLlamas = !ThiefTraderLlamaEntity.spawnLlamas(this, this.func_233580_cy_(), (ServerWorld)this.field_70170_p, 2);
        }
        if ((this.func_213716_dX() && this.lastCustomer != this.func_70931_l_() || !this.func_213716_dX()) && this.lastCustomer != null) {
            if (this.lastSales <= 0) {
                this.turnIntoThief(this.lastCustomer);
            }
            this.lastSales = 0;
        }
        this.lastCustomer = this.func_70931_l_();
        super.func_70636_d();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new EvilThiefWhenHitGoal(this));
    }

    public void turnIntoThief(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModEntityTypes.THIEF.get()), timer -> {})) {
            ThiefEntity thief = this.startConversion((ServerWorld)this.field_70170_p, player);
            this.forTraderLlamas(llama -> llama.turnIntoThiefLlama(player, thief));
        }
    }

    private ThiefEntity startConversion(ServerWorld serverWorld, PlayerEntity player) {
        ThiefEntity thief = (ThiefEntity)this.func_233656_b_((EntityType)ModEntityTypes.THIEF.get(), false);
        thief.setNemesis(player);
        thief.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(thief.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 200, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.func_184185_a((SoundEvent)ModSoundEventTypes.THIEF_CONVERSION.get(), 2.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.2f + 0.3f);
        for (int i = 0; i < 60; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.2;
            double d1 = this.field_70146_Z.nextGaussian() * 0.2;
            double d2 = this.field_70146_Z.nextGaussian() * 0.2;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197616_i, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 1, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197626_s, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 1, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226275_c_(0.0) - d0 * 10.0, this.func_226279_cv_() - d1 * 10.0, this.func_226287_g_(1.0) - d2 * 10.0, 1, 0.0, 0.0, 0.0, (d0 + d1 + d2) / 3.0);
        }
        this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151058_ca, 2));
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)thief);
        return thief;
    }

    protected void func_213712_ef() {
        MerchantOffers merchantoffers = this.func_213706_dY();
        this.forTraderLlamas(llama -> {
            for (int i = 0; i < llama.func_190686_di(); ++i) {
                MerchantOffer offer = llama.getMerchantOfferFromInventorySlot(i);
                if (offer == null) continue;
                merchantoffers.add((Object)offer);
            }
        });
        if (merchantoffers.size() == 0) {
            super.func_213712_ef();
        }
    }

    private void forTraderLlamas(Consumer<ThiefTraderLlamaEntity> consumer) {
        if (this.field_70170_p.field_72995_K || this.field_70170_p.func_72912_H().func_76073_f() <= 0L || !this.isAddedToWorld()) {
            return;
        }
        Double maxDistance = ThiefEntity.MAX_DISTANCE_TO_LLAMAS;
        List entities = this.field_70170_p.func_217357_a(ThiefTraderLlamaEntity.class, new AxisAlignedBB(this.func_226277_ct_() - maxDistance, this.func_226280_cw_() - maxDistance / 2.0, this.func_226281_cx_() - maxDistance, this.func_226277_ct_() + maxDistance, this.func_226280_cw_() + maxDistance / 2.0, this.func_226281_cx_() + maxDistance));
        if (!entities.isEmpty()) {
            for (ThiefTraderLlamaEntity llama : entities) {
                if (!llama.func_70089_S() || !llama.func_110167_bD() || !llama.func_110166_bE().equals((Object)this)) continue;
                consumer.accept(llama);
            }
        }
    }
}

