/*
 * Decompiled with CFR 0.152.
 */
package eu.tsp.evilwanderingtrader.common.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;

public class FollowEntityGoal
extends Goal {
    private final MobEntity follower;
    private final Predicate<MobEntity> followPredicate;
    private MobEntity followingEntity;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;

    public FollowEntityGoal(MobEntity follower, double speedModifier, float stopDistance, float areaSize, Predicate<MobEntity> followPredicate) {
        this.follower = follower;
        this.followPredicate = followPredicate;
        this.speedModifier = speedModifier;
        this.navigation = follower.func_70661_as();
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(follower.func_70661_as() instanceof GroundPathNavigator) && !(follower.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowEntityGoal");
        }
    }

    public boolean func_75250_a() {
        List list = this.follower.field_70170_p.func_175647_a(MobEntity.class, this.follower.func_174813_aQ().func_186662_g((double)this.areaSize), this.followPredicate);
        if (!list.isEmpty()) {
            for (MobEntity mobentity : list) {
                if (mobentity.func_82150_aj()) continue;
                this.followingEntity = mobentity;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.followingEntity != null && !this.navigation.func_75500_f() && this.follower.func_70068_e((Entity)this.followingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.follower.func_184643_a(PathNodeType.WATER);
        this.follower.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.followingEntity = null;
        this.navigation.func_75499_g();
        this.follower.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.followingEntity != null && !this.follower.func_110167_bD()) {
            this.follower.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.follower.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.timeToRecalcPath = 10;
                double d0 = this.follower.func_226277_ct_() - this.followingEntity.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.follower.func_226278_cu_() - this.followingEntity.func_226278_cu_()) * d1 + (d2 = this.follower.func_226281_cx_() - this.followingEntity.func_226281_cx_()) * d2;
                if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                    this.navigation.func_75497_a((Entity)this.followingEntity, this.speedModifier);
                } else {
                    this.navigation.func_75499_g();
                    LookController lookcontroller = this.followingEntity.func_70671_ap();
                    if (d3 <= (double)this.stopDistance || lookcontroller.func_180423_e() == this.follower.func_226277_ct_() && lookcontroller.func_180422_f() == this.follower.func_226278_cu_() && lookcontroller.func_180421_g() == this.follower.func_226281_cx_()) {
                        double d4 = this.followingEntity.func_226277_ct_() - this.follower.func_226277_ct_();
                        double d5 = this.followingEntity.func_226281_cx_() - this.follower.func_226281_cx_();
                        this.navigation.func_75492_a(this.follower.func_226277_ct_() - d4, this.follower.func_226278_cu_(), this.follower.func_226281_cx_() - d5, this.speedModifier);
                    }
                }
            }
        }
    }
}

