/*
 * Decompiled with CFR 0.152.
 */
package eu.tsp.evilwanderingtrader.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ModSpawnEggItem
extends SpawnEggItem {
    protected static final List<ModSpawnEggItem> UNADDED_EGGS = new ArrayList<ModSpawnEggItem>();
    private final Lazy<? extends EntityType<?>> entityTypeSupplier = Lazy.of(() -> entityTypeSupplier.get());
    private int variant = -1;

    public ModSpawnEggItem(RegistryObject<? extends EntityType<?>> entityTypeSupplier, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(null, primaryColorIn, secondaryColorIn, builder);
        UNADDED_EGGS.add(this);
    }

    public static void initSpawnEggs() {
        Map EGGS = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"field_195987_b");
        DefaultDispenseItemBehavior dispenseItemBehavior = new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                type.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d(), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (SpawnEggItem spawnEggItem : UNADDED_EGGS) {
            EGGS.put(spawnEggItem.func_208076_b(null), spawnEggItem);
            DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)dispenseItemBehavior);
        }
        UNADDED_EGGS.clear();
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT p_208076_1_) {
        return (EntityType)this.entityTypeSupplier.get();
    }

    public ModSpawnEggItem spawnsVariant(int variant) {
        this.variant = variant;
        return this;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("name")) {
                tooltip.add((ITextComponent)new StringTextComponent("Name: " + nbt.func_74779_i("name")));
            }
            if (nbt.func_74764_b("health")) {
                tooltip.add((ITextComponent)new StringTextComponent("Health: " + Math.round(nbt.func_74760_g("health"))));
            }
        }
    }
}

