/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Module;

public class CharmLoader {
    private final String MOD_ID;
    private final List<Class<? extends CharmModule>> CLASSES;
    private final Map<String, CharmModule> LOADED_MODULES = new TreeMap<String, CharmModule>();

    public CharmLoader(String modId, List<Class<? extends CharmModule>> classes) {
        this.MOD_ID = modId;
        this.CLASSES = classes;
        Charm.LOG.info("Setting up a new Charm-based module '" + modId + "'");
        this.register();
    }

    public String getModId() {
        return this.MOD_ID;
    }

    public List<Class<? extends CharmModule>> getClasses() {
        return this.CLASSES;
    }

    protected void register() {
        ModuleHandler.INSTANCE.addLoader(this);
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        this.CLASSES.forEach(clazz -> {
            try {
                Module annotation;
                CharmModule module = (CharmModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (clazz.isAnnotationPresent(Module.class)) {
                    annotation = clazz.getAnnotation(Module.class);
                    if (annotation.mod().isEmpty()) {
                        throw new Exception("mod name must be defined");
                    }
                } else {
                    throw new RuntimeException("No module annotation for class " + clazz.toString());
                }
                module.mod = annotation.mod();
                module.alwaysEnabled = annotation.alwaysEnabled();
                module.enabledByDefault = annotation.enabledByDefault();
                module.hasSubscriptions = annotation.hasSubscriptions();
                module.enabled = module.enabledByDefault;
                module.description = annotation.description();
                module.client = annotation.client();
                String moduleName = module.getName();
                this.LOADED_MODULES.put(moduleName, module);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize module class: " + clazz.toString(), e);
            }
        });
        ModuleHandler.CONFIG_HANDLER.createConfig(modContainer, this.LOADED_MODULES);
        this.LOADED_MODULES.forEach((moduleName, module) -> ModuleHandler.INSTANCE.register((CharmModule)module));
    }

    public void onModConfig(ModConfig.ModConfigEvent event) {
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        this.eachModule(module -> module.onCommonSetup(event));
        this.eachModule(ModuleHandler.INSTANCE::depends);
        this.eachEnabledModule(ModuleHandler.INSTANCE::init);
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        this.eachEnabledModule(m -> m.loadWorld(event.getServer()));
    }

    protected void eachModule(Consumer<CharmModule> consumer) {
        this.LOADED_MODULES.values().forEach(consumer);
    }

    protected void eachEnabledModule(Consumer<CharmModule> consumer) {
        this.LOADED_MODULES.values().stream().filter(m -> m.enabled).forEach(consumer);
    }
}

