/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.container;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import svenhjol.charm.module.Woodcutters;
import svenhjol.charm.recipe.WoodcuttingRecipe;

public class WoodcutterContainer
extends Container {
    private final IWorldPosCallable context;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<WoodcuttingRecipe> recipes = Lists.newArrayList();
    private ItemStack inputStack = ItemStack.field_190927_a;
    private long lastTakeTime;
    final Slot inputSlot;
    final Slot outputSlot;
    private Runnable contentsChangedListener = () -> {};
    public final Inventory inputInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            WoodcutterContainer.this.func_75130_a((IInventory)this);
            WoodcutterContainer.this.contentsChangedListener.run();
        }
    };
    private final CraftResultInventory inventory = new CraftResultInventory();

    public WoodcutterContainer(int syncId, PlayerInventory playerInventory) {
        this(syncId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public WoodcutterContainer(int syncId, PlayerInventory playerInventory, final IWorldPosCallable context) {
        super(Woodcutters.SCREEN_HANDLER, syncId);
        int k;
        this.context = context;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.inputSlot = this.func_75146_a(new Slot((IInventory)this.inputInventory, 0, 20, 33));
        this.outputSlot = this.func_75146_a(new Slot((IInventory)this.inventory, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                stack.func_77980_a(player.field_70170_p, player, stack.func_190916_E());
                WoodcutterContainer.this.inventory.func_201560_d(player);
                ItemStack itemStack = WoodcutterContainer.this.inputSlot.func_75209_a(1);
                if (!itemStack.func_190926_b()) {
                    WoodcutterContainer.this.updateRecipeResultSlot();
                }
                context.func_221486_a((world, blockPos) -> {
                    long l = world.func_82737_E();
                    if (WoodcutterContainer.this.lastTakeTime != l) {
                        world.func_184133_a(null, blockPos, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        WoodcutterContainer.this.lastTakeTime = l;
                    }
                });
                return super.func_190901_a(player, stack);
            }
        });
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + k * 9 + 9, 8 + j * 18, 84 + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WoodcuttingRecipe> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsInInputSlot() {
        return this.inputSlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity player) {
        return WoodcutterContainer.func_216963_a((IWorldPosCallable)this.context, (PlayerEntity)player, (Block)Woodcutters.WOODCUTTER);
    }

    public boolean func_75140_a(PlayerEntity player, int id) {
        if (this.func_241818_d_(id)) {
            this.selectedRecipe.func_221494_a(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean func_241818_d_(int i) {
        return i >= 0 && i < this.recipes.size();
    }

    public void func_75130_a(IInventory inventory) {
        ItemStack itemStack = this.inputSlot.func_75211_c();
        if (itemStack.func_77973_b() != this.inputStack.func_77973_b()) {
            this.inputStack = itemStack.func_77946_l();
            this.updateAvailableRecipes(inventory, itemStack);
        }
    }

    private void updateAvailableRecipes(IInventory input, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(Woodcutters.RECIPE_TYPE, input, this.world);
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.func_241818_d_(this.selectedRecipe.func_221495_b())) {
            WoodcuttingRecipe woodcuttingRecipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.inventory.func_193056_a((IRecipe)woodcuttingRecipe);
            this.outputSlot.func_75215_d(woodcuttingRecipe.func_77572_b((IInventory)this.inputInventory));
        } else {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public ContainerType<?> func_216957_a() {
        return Woodcutters.SCREEN_HANDLER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable runnable) {
        this.contentsChangedListener = runnable;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.inventory && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            itemstack = itemstack1.func_77946_l();
            if (index == 1) {
                item.func_77622_d(itemstack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (this.world.func_199532_z().func_215371_a(Woodcutters.RECIPE_TYPE, (IInventory)new Inventory(new ItemStack[]{itemstack1}), this.world).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.inventory.func_70304_b(1);
        this.context.func_221486_a((world, blockPos) -> this.func_193327_a(player, player.field_70170_p, (IInventory)this.inputInventory));
    }
}

