/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;
import svenhjol.charm.entity.goal.MoobloomPlantFlowerGoal;
import svenhjol.charm.module.Mooblooms;

public class MoobloomEntity
extends CowEntity
implements IShearable {
    private static final String TYPE_TAG = "Type";
    private static final String POLLINATED_TAG = "Pollinated";
    private static final DataParameter<String> TYPE;
    private static final DataParameter<Boolean> POLLINATED;
    public static Map<Type, ResourceLocation> TEXTURES;

    public MoobloomEntity(EntityType<? extends CowEntity> entityType, World world) {
        super(entityType, world);
        TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
            for (Type type : Type.values()) {
                map.put(type, new ResourceLocation("charm", "textures/entity/moobloom/" + type.name + ".png"));
            }
        });
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT entityTag) {
        entityData = super.func_213386_a(world, difficulty, spawnReason, entityData, entityTag);
        List<Type> types = Arrays.asList(Type.values());
        Type type = types.get(this.field_70146_Z.nextInt(types.size()));
        this.setMoobloomType(type);
        return entityData;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)Type.ALLIUM.name());
        this.field_70180_af.func_187214_a(POLLINATED, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new MoobloomPlantFlowerGoal(this));
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() == Items.field_151054_z && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K && this.isPollinated()) {
                ItemStack stew;
                Optional<Pair<Effect, Integer>> optionalFlower = this.getEffectFromFlower(this.getMoobloomType().flower);
                if (optionalFlower.isPresent()) {
                    Pair<Effect, Integer> effectFromFlower = optionalFlower.get();
                    Effect effect = (Effect)effectFromFlower.getLeft();
                    int duration = (Integer)effectFromFlower.getRight() * 2;
                    stew = new ItemStack((IItemProvider)Items.field_222115_pz);
                    this.func_184185_a(SoundEvents.field_219661_gy, 1.0f, 1.0f);
                    SuspiciousStewItem.func_220037_a((ItemStack)stew, (Effect)effect, (int)duration);
                } else {
                    stew = new ItemStack((IItemProvider)Items.field_151009_A);
                    this.func_184185_a(SoundEvents.field_219660_gx, 1.0f, 1.0f);
                }
                ItemStack out = DrinkHelper.func_241445_a_((ItemStack)held, (PlayerEntity)player, (ItemStack)stew, (boolean)false);
                player.func_184611_a(hand, out);
                this.field_70180_af.func_187227_b(POLLINATED, (Object)false);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (held.func_77973_b() == Items.field_151097_aZ && this.func_230262_K__()) {
            this.func_230263_a_(SoundCategory.PLAYERS);
            if (!this.field_70170_p.field_72995_K) {
                held.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74778_a(TYPE_TAG, this.getMoobloomType().name);
        tag.func_74757_a(POLLINATED_TAG, ((Boolean)this.field_70180_af.func_187225_a(POLLINATED)).booleanValue());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setMoobloomType(Type.fromName(tag.func_74779_i(TYPE_TAG)));
        if (tag.func_74764_b(POLLINATED_TAG)) {
            this.field_70180_af.func_187227_b(POLLINATED, (Object)tag.func_74767_n(POLLINATED_TAG));
        }
    }

    public MoobloomEntity func_241840_a(ServerWorld serverWorld, AgeableEntity passiveEntity) {
        MoobloomEntity entity = (MoobloomEntity)Mooblooms.MOOBLOOM.func_200721_a((World)serverWorld);
        Type childType = serverWorld.field_73012_v.nextFloat() < 0.5f ? this.getMoobloomType() : ((MoobloomEntity)passiveEntity).getMoobloomType();
        entity.setMoobloomType(childType);
        return entity;
    }

    public void pollinate() {
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_226129_ad_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        this.field_70180_af.func_187227_b(POLLINATED, (Object)true);
    }

    public boolean isPollinated() {
        return (Boolean)this.field_70180_af.func_187225_a(POLLINATED);
    }

    public Type getMoobloomType() {
        return Type.fromName((String)this.field_70180_af.func_187225_a(MoobloomEntity.TYPE));
    }

    public void setMoobloomType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.name);
    }

    public ResourceLocation getMoobloomTexture() {
        return TEXTURES.getOrDefault((Object)this.getMoobloomType(), TEXTURES.get((Object)Type.ALLIUM));
    }

    public Optional<Pair<Effect, Integer>> getEffectFromFlower(BlockState flower) {
        Block block = flower.func_177230_c();
        if (block instanceof FlowerBlock) {
            FlowerBlock flowerBlock = (FlowerBlock)block;
            return Optional.of(Pair.of((Object)flowerBlock.func_220094_d(), (Object)flowerBlock.func_220095_e()));
        }
        return Optional.empty();
    }

    public static boolean canSpawn(EntityType<MoobloomEntity> type, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return world.func_226659_b_(pos, 0) > 8;
    }

    public void func_230263_a_(SoundCategory shearedSoundCategory) {
        this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187784_dt, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.func_70106_y();
            CowEntity cowEntity = (CowEntity)EntityType.field_200796_j.func_200721_a(this.field_70170_p);
            cowEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowEntity.func_70606_j(this.func_110143_aJ());
            cowEntity.field_70761_aq = this.field_70761_aq;
            if (this.func_145818_k_()) {
                cowEntity.func_200203_b(this.func_200201_e());
                cowEntity.func_174805_g(this.func_174833_aM());
            }
            if (this.func_104002_bU()) {
                cowEntity.func_110163_bv();
            }
            cowEntity.func_184224_h(this.func_190530_aW());
            this.field_70170_p.func_217376_c((Entity)cowEntity);
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226283_e_(1.0), this.func_226281_cx_(), new ItemStack((IItemProvider)this.getMoobloomType().flower.func_177230_c())));
            }
        }
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    static {
        TEXTURES = new HashMap<Type, ResourceLocation>();
        TYPE = EntityDataManager.func_187226_a(MoobloomEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
        POLLINATED = EntityDataManager.func_187226_a(MoobloomEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    }

    public static enum Type {
        ALLIUM("allium", Blocks.field_196609_bf.func_176223_P()),
        AZURE_BLUET("azure_bluet", Blocks.field_196610_bg.func_176223_P()),
        BLUE_ORCHID("blue_orchid", Blocks.field_196607_be.func_176223_P()),
        CORNFLOWER("cornflower", Blocks.field_222387_by.func_176223_P()),
        DANDELION("dandelion", Blocks.field_196605_bc.func_176223_P()),
        LILY_OF_THE_VALLEY("lily_of_the_valley", Blocks.field_222383_bA.func_176223_P()),
        ORANGE_TULIP("orange_tulip", Blocks.field_196613_bi.func_176223_P()),
        PINK_TULIP("pink_tulip", Blocks.field_196615_bk.func_176223_P()),
        RED_TULIP("red_tulip", Blocks.field_196612_bh.func_176223_P()),
        WHITE_TULIP("white_tulip", Blocks.field_196614_bj.func_176223_P()),
        OXEYE_DAISY("oxeye_daisy", Blocks.field_196616_bl.func_176223_P()),
        POPPY("poppy", Blocks.field_196606_bd.func_176223_P());

        private final String name;
        private final BlockState flower;

        private Type(String name, BlockState flower) {
            this.name = name;
            this.flower = flower;
        }

        public BlockState getFlower() {
            return this.flower;
        }

        private static Type fromName(String name) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.name.equals(name)) continue;
                return value;
            }
            return ALLIUM;
        }
    }
}

