/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import svenhjol.charm.mixin.accessor.MinecraftAccessor;
import svenhjol.charm.mixin.accessor.RenderStateAccessor;
import svenhjol.charm.mixin.accessor.RenderTypeAccessor;
import svenhjol.charm.mixin.accessor.RenderTypeBuffersMixin;
import svenhjol.charm.module.Core;

public class ColoredGlintHandler {
    public static final String GLINT_TAG = "charm_glint";
    public static Map<String, ResourceLocation> TEXTURES = new HashMap<String, ResourceLocation>();
    public static Map<String, RenderType> GLINT = new HashMap<String, RenderType>();
    public static Map<String, RenderType> ENTITY_GLINT = new HashMap<String, RenderType>();
    public static Map<String, RenderType> DIRECT_GLINT = new HashMap<String, RenderType>();
    public static Map<String, RenderType> DIRECT_ENTITY_GLINT = new HashMap<String, RenderType>();
    public static Map<String, RenderType> ARMOR_GLINT = new HashMap<String, RenderType>();
    public static Map<String, RenderType> ARMOR_ENTITY_GLINT = new HashMap<String, RenderType>();
    public static String defaultGlintColor;
    public static ItemStack targetStack;
    private static boolean hasInit;

    public static void init() {
        if (hasInit) {
            return;
        }
        for (DyeColor dyeColor : DyeColor.values()) {
            String color = dyeColor.func_176610_l();
            TEXTURES.put(color, new ResourceLocation("charm", "textures/misc/" + color + "_glint.png"));
            GLINT.put(color, ColoredGlintHandler.createGlint(color, TEXTURES.get(color)));
            ENTITY_GLINT.put(color, ColoredGlintHandler.createEntityGlint(color, TEXTURES.get(color)));
            DIRECT_GLINT.put(color, ColoredGlintHandler.createDirectGlint(color, TEXTURES.get(color)));
            DIRECT_ENTITY_GLINT.put(color, ColoredGlintHandler.createDirectEntityGlint(color, TEXTURES.get(color)));
            ARMOR_GLINT.put(color, ColoredGlintHandler.createArmorGlint(color, TEXTURES.get(color)));
            ARMOR_ENTITY_GLINT.put(color, ColoredGlintHandler.createArmorEntityGlint(color, TEXTURES.get(color)));
        }
        List validColors = Arrays.stream(DyeColor.values()).map(DyeColor::func_176610_l).collect(Collectors.toList());
        validColors.add("rainbow");
        defaultGlintColor = validColors.contains(Core.glintColor) ? Core.glintColor : DyeColor.PURPLE.func_176610_l();
        hasInit = true;
    }

    public static String getDefaultGlintColor() {
        return defaultGlintColor;
    }

    public static String getStackColor(ItemStack stack) {
        CompoundNBT tag;
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()) != null && tag.func_74764_b(GLINT_TAG)) {
            return tag.func_74779_i(GLINT_TAG);
        }
        return ColoredGlintHandler.getDefaultGlintColor();
    }

    public static RenderType getArmorGlintRenderLayer() {
        return ARMOR_GLINT.getOrDefault(ColoredGlintHandler.getStackColor(targetStack), RenderTypeAccessor.getArmorGlint());
    }

    public static RenderType getArmorEntityGlintRenderLayer() {
        return ARMOR_ENTITY_GLINT.getOrDefault(ColoredGlintHandler.getStackColor(targetStack), RenderTypeAccessor.getArmorEntityGlint());
    }

    public static RenderType getDirectGlintRenderLayer() {
        return DIRECT_GLINT.getOrDefault(ColoredGlintHandler.getStackColor(targetStack), RenderTypeAccessor.getDirectGlint());
    }

    public static RenderType getDirectEntityGlintRenderLayer() {
        return DIRECT_ENTITY_GLINT.getOrDefault(ColoredGlintHandler.getStackColor(targetStack), RenderTypeAccessor.getDirectEntityGlint());
    }

    public static RenderType getEntityGlintRenderLayer() {
        return ENTITY_GLINT.getOrDefault(ColoredGlintHandler.getStackColor(targetStack), RenderTypeAccessor.getEntityGlint());
    }

    public static RenderType getGlintRenderLayer() {
        return GLINT.getOrDefault(ColoredGlintHandler.getStackColor(targetStack), RenderTypeAccessor.getGlint());
    }

    private static RenderType createGlint(String color, ResourceLocation texture) {
        RenderType.Type renderLayer = RenderType.func_228632_a_((String)("glint_" + color), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228727_a_(RenderStateAccessor.getColorWrite()).func_228714_a_(RenderStateAccessor.getCullDisabled()).func_228715_a_(RenderStateAccessor.getDepthEqual()).func_228726_a_(RenderStateAccessor.getGlintTransparency()).func_228725_a_(RenderStateAccessor.getGlintTexturing()).func_228728_a_(false));
        ColoredGlintHandler.getEntityBuilders().put((RenderType)renderLayer, new BufferBuilder(renderLayer.func_228662_o_()));
        return renderLayer;
    }

    private static RenderType createEntityGlint(String color, ResourceLocation texture) {
        RenderType.Type renderLayer = RenderType.func_228632_a_((String)("entity_glint_" + color), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228727_a_(RenderStateAccessor.getColorWrite()).func_228714_a_(RenderStateAccessor.getCullDisabled()).func_228715_a_(RenderStateAccessor.getDepthEqual()).func_228726_a_(RenderStateAccessor.getGlintTransparency()).func_228725_a_(RenderStateAccessor.getEntityGlintTexturing()).func_228721_a_(RenderStateAccessor.getItemTarget()).func_228728_a_(false));
        ColoredGlintHandler.getEntityBuilders().put((RenderType)renderLayer, new BufferBuilder(renderLayer.func_228662_o_()));
        return renderLayer;
    }

    private static RenderType createArmorGlint(String color, ResourceLocation texture) {
        RenderType.Type renderLayer = RenderType.func_228632_a_((String)("armor_glint_" + color), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228727_a_(RenderStateAccessor.getColorWrite()).func_228714_a_(RenderStateAccessor.getCullDisabled()).func_228715_a_(RenderStateAccessor.getDepthEqual()).func_228726_a_(RenderStateAccessor.getGlintTransparency()).func_228725_a_(RenderStateAccessor.getGlintTexturing()).func_228718_a_(RenderStateAccessor.getViewOffsetZLayering()).func_228728_a_(false));
        ColoredGlintHandler.getEntityBuilders().put((RenderType)renderLayer, new BufferBuilder(renderLayer.func_228662_o_()));
        return renderLayer;
    }

    private static RenderType createArmorEntityGlint(String color, ResourceLocation texture) {
        RenderType.Type renderLayer = RenderType.func_228632_a_((String)("armor_entity_glint_" + color), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228727_a_(RenderStateAccessor.getColorWrite()).func_228714_a_(RenderStateAccessor.getCullDisabled()).func_228715_a_(RenderStateAccessor.getDepthEqual()).func_228726_a_(RenderStateAccessor.getGlintTransparency()).func_228725_a_(RenderStateAccessor.getEntityGlintTexturing()).func_228718_a_(RenderStateAccessor.getViewOffsetZLayering()).func_228728_a_(false));
        ColoredGlintHandler.getEntityBuilders().put((RenderType)renderLayer, new BufferBuilder(renderLayer.func_228662_o_()));
        return renderLayer;
    }

    private static RenderType createDirectGlint(String color, ResourceLocation texture) {
        RenderType.Type renderLayer = RenderType.func_228632_a_((String)("glint_direct_" + color), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228727_a_(RenderStateAccessor.getColorWrite()).func_228714_a_(RenderStateAccessor.getCullDisabled()).func_228715_a_(RenderStateAccessor.getDepthEqual()).func_228726_a_(RenderStateAccessor.getGlintTransparency()).func_228725_a_(RenderStateAccessor.getGlintTexturing()).func_228728_a_(false));
        ColoredGlintHandler.getEntityBuilders().put((RenderType)renderLayer, new BufferBuilder(renderLayer.func_228662_o_()));
        return renderLayer;
    }

    private static RenderType createDirectEntityGlint(String color, ResourceLocation texture) {
        RenderType.Type renderLayer = RenderType.func_228632_a_((String)("entity_glint_direct_" + color), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, true, false)).func_228727_a_(RenderStateAccessor.getColorWrite()).func_228714_a_(RenderStateAccessor.getCullDisabled()).func_228715_a_(RenderStateAccessor.getDepthEqual()).func_228726_a_(RenderStateAccessor.getGlintTransparency()).func_228725_a_(RenderStateAccessor.getEntityGlintTexturing()).func_228721_a_(RenderStateAccessor.getItemTarget()).func_228728_a_(false));
        ColoredGlintHandler.getEntityBuilders().put((RenderType)renderLayer, new BufferBuilder(renderLayer.func_228662_o_()));
        return renderLayer;
    }

    private static SortedMap<RenderType, BufferBuilder> getEntityBuilders() {
        RenderTypeBuffers bufferBuilders = ((MinecraftAccessor)Minecraft.func_71410_x()).getRenderTypeBuffers();
        return ((RenderTypeBuffersMixin)bufferBuilders).getFixedBuffers();
    }

    static {
        hasInit = false;
    }
}

