/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.message;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import svenhjol.charm.base.iface.ICharmMessage;
import svenhjol.charm.module.Atlas;

public class ServerAtlasTransfer
implements ICharmMessage {
    public final int atlasSlot;
    public final int mapX;
    public final int mapZ;
    public final MoveMode mode;

    public ServerAtlasTransfer(int atlasSlot, int mapX, int mapZ, MoveMode mode) {
        this.atlasSlot = atlasSlot;
        this.mapX = mapX;
        this.mapZ = mapZ;
        this.mode = mode;
    }

    public static void encode(ServerAtlasTransfer msg, PacketBuffer buf) {
        buf.func_150787_b(msg.atlasSlot);
        buf.writeInt(msg.mapX);
        buf.writeInt(msg.mapZ);
        buf.func_179249_a((Enum)msg.mode);
    }

    public static ServerAtlasTransfer decode(PacketBuffer buf) {
        return new ServerAtlasTransfer(buf.func_150792_a(), buf.readInt(), buf.readInt(), (MoveMode)buf.func_179257_a(MoveMode.class));
    }

    public static class Handler {
        public static void handle(ServerAtlasTransfer msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
                ServerPlayerEntity player = context.getSender();
                if (player == null) {
                    return;
                }
                Atlas.serverCallback(player, msg);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum MoveMode {
        TO_HAND,
        TO_INVENTORY,
        FROM_HAND,
        FROM_INVENTORY;

    }
}

