/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.container.CartographyContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.helper.ItemNBTHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.AtlasClient;
import svenhjol.charm.container.AtlasContainer;
import svenhjol.charm.container.AtlasInventory;
import svenhjol.charm.item.AtlasItem;
import svenhjol.charm.message.ClientUpdateAtlasInventory;
import svenhjol.charm.message.ServerAtlasTransfer;

@Module(mod="charm", client=AtlasClient.class, description="Storage for maps that automatically updates the displayed map as you explore.", hasSubscriptions=true)
public class Atlas
extends CharmModule {
    public static final ResourceLocation ID = new ResourceLocation("charm", "atlas");
    public static final List<Item> VALID_ATLAS_ITEMS = new ArrayList<Item>();
    private static final Map<UUID, AtlasInventory> serverCache = new HashMap<UUID, AtlasInventory>();
    private static final Map<UUID, AtlasInventory> clientCache = new HashMap<UUID, AtlasInventory>();
    @Config(name="Open in off hand", description="Allow opening the atlas while it is in the off hand.")
    public static boolean offHandOpen = false;
    @Config(name="Map scale", description="Map scale used in atlases by default.")
    public static int defaultScale = 0;
    public static AtlasItem ATLAS_ITEM;
    public static ContainerType<AtlasContainer> CONTAINER;

    public static boolean inventoryContainsMap(PlayerInventory inventory, ItemStack itemStack) {
        if (inventory.func_70431_c(itemStack)) {
            return true;
        }
        if (ModuleHandler.enabled(Atlas.class)) {
            for (Hand hand : Hand.values()) {
                AtlasInventory inv;
                ItemStack atlasStack = inventory.field_70458_d.func_184586_b(hand);
                if (atlasStack.func_77973_b() != ATLAS_ITEM || !(inv = Atlas.getInventory(inventory.field_70458_d.field_70170_p, atlasStack)).hasItemStack(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static AtlasInventory getInventory(World world, ItemStack stack) {
        Map<UUID, AtlasInventory> cache;
        AtlasInventory inventory;
        UUID id = ItemNBTHelper.getUuid(stack, "id");
        if (id == null) {
            id = UUID.randomUUID();
            ItemNBTHelper.setUuid(stack, "id", id);
        }
        if ((inventory = (cache = world.field_72995_K ? clientCache : serverCache).get(id)) == null) {
            inventory = new AtlasInventory(stack);
            cache.put(id, inventory);
        }
        if (inventory.getAtlasItem() != stack) {
            inventory.reload(stack);
        }
        return inventory;
    }

    public static void sendMapToClient(ServerPlayerEntity player, ItemStack map, boolean markDirty) {
        if (map.func_77973_b().func_77643_m_()) {
            if (markDirty) {
                FilledMapItem.func_195950_a((ItemStack)map, (World)player.field_70170_p).func_176053_a(0, 0);
            }
            map.func_77973_b().func_77663_a(map, player.field_70170_p, (Entity)player, -1, true);
            IPacket packet = ((AbstractMapItem)map.func_77973_b()).func_150911_c(map, player.field_70170_p, (PlayerEntity)player);
            if (packet != null) {
                player.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public static void serverCallback(ServerPlayerEntity player, ServerAtlasTransfer msg) {
        AtlasInventory inventory = Atlas.getInventory(player.field_70170_p, player.field_71071_by.func_70301_a(msg.atlasSlot));
        switch (msg.mode) {
            case TO_HAND: {
                player.field_71071_by.func_70437_b(inventory.removeMapByCoords((World)player.field_70170_p, (int)msg.mapX, (int)msg.mapZ).map);
                player.func_71113_k();
                Atlas.updateClient(player, msg.atlasSlot);
                break;
            }
            case TO_INVENTORY: {
                player.func_191521_c(inventory.removeMapByCoords((World)player.field_70170_p, (int)msg.mapX, (int)msg.mapZ).map);
                Atlas.updateClient(player, msg.atlasSlot);
                break;
            }
            case FROM_HAND: {
                ItemStack heldItem = player.field_71071_by.func_70445_o();
                if (heldItem.func_77973_b() != Items.field_151098_aY || FilledMapItem.func_195950_a((ItemStack)heldItem, (World)player.field_70170_p).field_76197_d != inventory.getScale()) break;
                inventory.addToInventory(player.field_70170_p, heldItem);
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                player.func_71113_k();
                Atlas.updateClient(player, msg.atlasSlot);
                break;
            }
            case FROM_INVENTORY: {
                ItemStack stack = player.field_71071_by.func_70301_a(msg.mapX);
                if (stack.func_77973_b() != Items.field_151098_aY || FilledMapItem.func_195950_a((ItemStack)stack, (World)player.field_70170_p).field_76197_d != inventory.getScale()) break;
                inventory.addToInventory(player.field_70170_p, stack);
                player.field_71071_by.func_70304_b(msg.mapX);
                Atlas.updateClient(player, msg.atlasSlot);
            }
        }
    }

    public static void updateClient(ServerPlayerEntity player, int atlasSlot) {
        Charm.PACKET_HANDLER.sendToPlayer(new ClientUpdateAtlasInventory(atlasSlot), player);
    }

    private static AtlasInventory findAtlas(PlayerInventory inventory) {
        for (Hand hand : Hand.values()) {
            ItemStack stack = inventory.field_70458_d.func_184586_b(hand);
            if (stack.func_77973_b() != ATLAS_ITEM) continue;
            return Atlas.getInventory(inventory.field_70458_d.field_70170_p, stack);
        }
        throw new IllegalStateException("No atlas in any hand, can't open!");
    }

    public static void setupAtlasUpscale(final PlayerInventory playerInventory, CartographyContainer container) {
        if (ModuleHandler.enabled(Atlas.class)) {
            final Slot oldSlot = (Slot)container.field_75151_b.get(0);
            container.field_75151_b.set(0, new Slot(oldSlot.field_75224_c, oldSlot.getSlotIndex(), oldSlot.field_75223_e, oldSlot.field_75221_f){

                public boolean func_75214_a(ItemStack stack) {
                    return oldSlot.func_75214_a(stack) || stack.func_77973_b() == ATLAS_ITEM && Atlas.getInventory(playerInventory.field_70458_d.field_70170_p, stack).getMapInfos().isEmpty();
                }
            });
        }
    }

    public static boolean makeAtlasUpscaleOutput(ItemStack topStack, ItemStack bottomStack, ItemStack outputStack, World world, CraftResultInventory craftResultInventory, CartographyContainer cartographyContainer) {
        if (ModuleHandler.enabled(Atlas.class) && topStack.func_77973_b() == ATLAS_ITEM) {
            ItemStack output;
            AtlasInventory inventory = Atlas.getInventory(world, topStack);
            if (inventory.getMapInfos().isEmpty() && bottomStack.func_77973_b() == Items.field_151148_bJ && inventory.getScale() < 4) {
                output = topStack.func_77946_l();
                ItemNBTHelper.setUuid(output, "id", UUID.randomUUID());
                ItemNBTHelper.setInt(output, "scale", inventory.getScale() + 1);
            } else {
                output = ItemStack.field_190927_a;
            }
            if (!ItemStack.func_77989_b((ItemStack)output, (ItemStack)outputStack)) {
                craftResultInventory.func_70299_a(2, output);
                cartographyContainer.func_75142_b();
            }
            return true;
        }
        return false;
    }

    @Override
    public void register() {
        ATLAS_ITEM = new AtlasItem(this);
        VALID_ATLAS_ITEMS.add(Items.field_151148_bJ);
        VALID_ATLAS_ITEMS.add(Items.field_151098_aY);
        CONTAINER = RegistryHandler.container(ID, (syncId, playerInventory) -> new AtlasContainer(syncId, playerInventory, Atlas.findAtlas(playerInventory)));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            for (Hand hand : Hand.values()) {
                AtlasInventory inventory;
                ItemStack atlas = player.func_184586_b(hand);
                if (atlas.func_77973_b() != ATLAS_ITEM || !(inventory = Atlas.getInventory(player.field_70170_p, atlas)).updateActiveMap(player)) continue;
                Atlas.updateClient(player, Atlas.getSlotFromHand((PlayerEntity)player, hand));
            }
        }
    }

    private static int getSlotFromHand(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return player.field_71071_by.field_70461_c;
        }
        return player.field_71071_by.func_70302_i_() - 1;
    }
}

