/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.ModHelper;
import svenhjol.charm.base.helper.StructureHelper;
import svenhjol.charm.base.helper.VillagerHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.mixin.accessor.PointOfInterestTypeAccessor;
import svenhjol.charm.village.BeekeeperTradeOffers;

@Module(mod="charm", description="Beekeepers are villagers that trade beekeeping items. Their job site is the beehive.", hasSubscriptions=true)
public class Beekeepers
extends CharmModule {
    public static ResourceLocation ID = new ResourceLocation("charm", "beekeeper");
    public static VillagerProfession BEEKEEPER;
    @Config(name="Beekeeper house weight", description="Chance of a custom building to spawn. For reference, a vanilla library is 5.")
    public static int buildingWeight;
    @Config(name="Override", description="This module is automatically disabled if Buzzier Bees is present. Set true to force enable.")
    public static boolean override;

    @Override
    public void register() {
        BEEKEEPER = VillagerHelper.addProfession(ID, PointOfInterestType.field_226356_s_, SoundEvents.field_226134_ai_);
    }

    @Override
    public boolean depends() {
        return !ModHelper.isLoaded("buzzier_bees") || override;
    }

    @Override
    public void init() {
        ((PointOfInterestTypeAccessor)PointOfInterestType.field_226356_s_).setMaxFreeTickets(1);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.PLAINS, new ResourceLocation("charm:village/plains/houses/plains_beejack"), buildingWeight);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.PLAINS, new ResourceLocation("charm:village/plains/houses/plains_beekeeper_1"), buildingWeight);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.DESERT, new ResourceLocation("charm:village/desert/houses/desert_beekeeper_1"), buildingWeight);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.SAVANNA, new ResourceLocation("charm:village/savanna/houses/savanna_beekeeper_1"), buildingWeight);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.SAVANNA, new ResourceLocation("charm:village/savanna/houses/savanna_beekeeper_2"), buildingWeight);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.TAIGA, new ResourceLocation("charm:village/taiga/houses/taiga_beekeeper_1"), buildingWeight);
        StructureHelper.addVillageHouse(StructureHelper.VillageType.SNOWY, new ResourceLocation("charm:village/snowy/houses/snowy_lumberbee_1"), buildingWeight);
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == BEEKEEPER) {
            Int2ObjectMap trades = event.getTrades();
            trades.put(1, Arrays.asList(new BeekeeperTradeOffers.EmeraldsForFlowers(), new BeekeeperTradeOffers.BottlesForEmerald()));
            trades.put(2, Arrays.asList(new BeekeeperTradeOffers.EmeraldsForCharcoal(), new BeekeeperTradeOffers.BeeswaxForEmeralds()));
            trades.put(3, Arrays.asList(new BeekeeperTradeOffers.EmeraldsForHoneycomb(), new BeekeeperTradeOffers.CampfireForEmerald()));
            trades.put(4, Arrays.asList(new BeekeeperTradeOffers.LeadForEmeralds()));
            trades.put(5, Arrays.asList(new BeekeeperTradeOffers.PopulatedBeehiveForEmeralds()));
        }
    }

    static {
        buildingWeight = 5;
        override = false;
    }
}

