/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.helper.MobHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.CoralSquidsClient;
import svenhjol.charm.entity.CoralSquidEntity;
import svenhjol.charm.item.CoralSquidBucketItem;

@Module(mod="charm", client=CoralSquidsClient.class, hasSubscriptions=true, description="Coral Squids spawn near coral in warm oceans.")
public class CoralSquids
extends CharmModule {
    public static ResourceLocation ID = new ResourceLocation("charm", "coral_squid");
    public static ResourceLocation EGG_ID = new ResourceLocation("charm", "coral_squid_spawn_egg");
    public static CoralSquidBucketItem CORAL_SQUID_BUCKET;
    public static EntityType<CoralSquidEntity> CORAL_SQUID;
    public static Item SPAWN_EGG;
    public CoralSquidsClient client;
    @Config(name="Drop chance", description="Chance (out of 1.0) of a coral squid dropping coral when killed by the player.")
    public static double dropChance;
    @Config(name="Spawn weight", description="Chance of coral squids spawning in warm ocean biomes.")
    public static int spawnWeight;
    private List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();

    @Override
    public void register() {
        CORAL_SQUID = RegistryHandler.entity(ID, EntityType.Builder.func_220322_a(CoralSquidEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.54f, 0.54f).func_233606_a_(8));
        SPAWN_EGG = RegistryHandler.item(EGG_ID, (Item)new SpawnEggItem(CORAL_SQUID, 255, 0xFF00FF, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        EntitySpawnPlacementRegistry.func_209343_a(CORAL_SQUID, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CoralSquidEntity::canSpawn);
        CORAL_SQUID_BUCKET = new CoralSquidBucketItem(this);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        MobHelper.setEntityAttributes(CORAL_SQUID, CoralSquidEntity.createSquidAttributes().func_233813_a_());
    }

    @Override
    public void init() {
        this.biomes = new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft:warm_ocean"), new ResourceLocation("minecraft:deep_warn_ocean")));
    }

    @SubscribeEvent
    public void on(BiomeLoadingEvent event) {
        if (!event.isCanceled()) {
            this.tryAddEntityToSpawn(event);
        }
    }

    private void tryAddEntityToSpawn(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        if (!this.biomes.contains(event.getName())) {
            return;
        }
        List spawner = event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT);
        spawner.add(new MobSpawnInfo.Spawners(CORAL_SQUID, spawnWeight, 5, 6));
    }

    static {
        dropChance = 0.2;
        spawnWeight = 50;
    }
}

