/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.base.enums.VanillaVariantMaterial;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.helper.ItemHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.block.CrateBlock;
import svenhjol.charm.client.CratesClient;
import svenhjol.charm.container.CrateContainer;
import svenhjol.charm.tileentity.CrateTileEntity;

@Module(mod="charm", client=CratesClient.class, description="A smaller storage solution with the benefit of being transportable.", hasSubscriptions=true)
public class Crates
extends CharmModule {
    public static final ResourceLocation ID = new ResourceLocation("charm", "crate");
    public static final Map<IVariantMaterial, CrateBlock> CRATE_BLOCKS = new HashMap<IVariantMaterial, CrateBlock>();
    public static ContainerType<CrateContainer> CONTAINER;
    public static TileEntityType<CrateTileEntity> TILE_ENTITY;
    public static final List<Class<? extends Block>> INVALID_CRATE_BLOCKS;
    public static final List<Class<? extends Block>> INVALID_SHULKER_BOX_BLOCKS;
    @Config(name="Show tooltip", description="If true, hovering over a crate will show its contents in a tooltip.")
    public static boolean showTooltip;

    @Override
    public void register() {
        for (VanillaVariantMaterial type : VanillaVariantMaterial.values()) {
            CRATE_BLOCKS.put(type, new CrateBlock(this, type));
        }
        INVALID_CRATE_BLOCKS.add(ShulkerBoxBlock.class);
        INVALID_CRATE_BLOCKS.add(CrateBlock.class);
        INVALID_SHULKER_BOX_BLOCKS.add(CrateBlock.class);
        CONTAINER = RegistryHandler.container(ID, CrateContainer::new);
        TILE_ENTITY = RegistryHandler.tileEntity(ID, CrateTileEntity::new, new Block[0]);
    }

    public static boolean canCrateInsertItem(ItemStack stack) {
        return !ModuleHandler.enabled(Crates.class) || !INVALID_CRATE_BLOCKS.contains(ItemHelper.getBlockClass(stack));
    }

    public static boolean canShulkerBoxInsertItem(ItemStack stack) {
        return !ModuleHandler.enabled(Crates.class) || !INVALID_SHULKER_BOX_BLOCKS.contains(ItemHelper.getBlockClass(stack));
    }

    public static CrateBlock getRandomCrateBlock(Random rand) {
        ArrayList<CrateBlock> values = new ArrayList<CrateBlock>(CRATE_BLOCKS.values());
        return (CrateBlock)values.get(rand.nextInt(values.size()));
    }

    static {
        INVALID_CRATE_BLOCKS = new ArrayList<Class<? extends Block>>();
        INVALID_SHULKER_BOX_BLOCKS = new ArrayList<Class<? extends Block>>();
        showTooltip = true;
    }
}

