/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.module.AnvilImprovements;
import svenhjol.charm.module.NetheriteNuggets;

@Module(mod="charm", description="Combine a tool or armor with a netherite nugget on an anvil to reduce its repair cost.", hasSubscriptions=true)
public class DecreaseRepairCost
extends CharmModule {
    @Config(name="XP cost", description="Number of levels required to reduce repair cost on the anvil.")
    public static int xpCost = 0;
    @Config(name="Repair cost decrease", description="The tool repair cost will be decreased by this amount.")
    public static int decreaseAmount = 5;

    @Override
    public void init() {
        if (!ModuleHandler.enabled(AnvilImprovements.class) && xpCost < 1) {
            xpCost = 1;
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!event.isCanceled()) {
            this.tryReduceRepairCost(event);
        }
    }

    private void tryReduceRepairCost(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        if (right.func_77973_b() != NetheriteNuggets.NETHERITE_NUGGET) {
            return;
        }
        if (left.func_82838_A() == 0) {
            return;
        }
        int cost = left.func_82838_A();
        ItemStack out = left.func_77946_l();
        out.func_82841_c(Math.max(0, cost - decreaseAmount));
        event.setCost(xpCost);
        event.setMaterialCost(1);
        event.setOutput(out);
    }
}

