/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.helper.ItemHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.EndermitePowderClient;
import svenhjol.charm.entity.EndermitePowderEntity;
import svenhjol.charm.item.EndermitePowderItem;

@Module(mod="charm", client=EndermitePowderClient.class, description="Endermites drop endermite powder that can be used to locate an End City.", hasSubscriptions=true)
public class EndermitePowder
extends CharmModule {
    public static ResourceLocation ID = new ResourceLocation("charm", "endermite_powder");
    public static EntityType<EndermitePowderEntity> ENTITY;
    public static EndermitePowderItem ENDERMITE_POWDER;
    public static double lootingBoost;
    @Config(name="Maximum drops", description="Maximum endermite powder dropped when endermite is killed.")
    public static int maxDrops;

    @Override
    public void register() {
        ENDERMITE_POWDER = new EndermitePowderItem(this);
        ENTITY = RegistryHandler.entity(ID, EntityType.Builder.func_220322_a(EndermitePowderEntity::new, (EntityClassification)EntityClassification.MISC).func_233606_a_(80).setUpdateInterval(10).func_220321_a(2.0f, 2.0f));
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled()) {
            this.tryDrop((Entity)event.getEntityLiving(), event.getSource(), event.getLootingLevel());
        }
    }

    private void tryDrop(Entity entity, DamageSource source, int lootingLevel) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EndermiteEntity) {
            World world = entity.func_130014_f_();
            BlockPos pos = entity.func_233580_cy_();
            int amount = ItemHelper.getAmountWithLooting(world.field_73012_v, maxDrops, lootingLevel, (float)lootingBoost);
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ENDERMITE_POWDER, amount)));
        }
    }

    static {
        lootingBoost = 0.3;
        maxDrops = 2;
    }
}

