/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import com.mojang.brigadier.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Right-click with a hoe to quickly harvest and replant a fully-grown crop.", hasSubscriptions=true)
public class HoeHarvesting
extends CharmModule {
    private static final List<BlockState> harvestable = new ArrayList<BlockState>();
    @Config(name="Override", description="This module is automatically disabled if Quark is present. Set true to force enable.")
    public static boolean override = false;

    @Override
    public boolean depends() {
        return !ModuleHandler.enabled("quark:tweaks.module.hoe_harvesting_module") || override;
    }

    @Override
    public void init() {
        HoeHarvesting.addHarvestable("minecraft:beetroots[age=3]");
        HoeHarvesting.addHarvestable("minecraft:carrots[age=7]");
        HoeHarvesting.addHarvestable("minecraft:nether_wart[age=3]");
        HoeHarvesting.addHarvestable("minecraft:potatoes[age=7]");
        HoeHarvesting.addHarvestable("minecraft:wheat[age=7]");
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.isCanceled()) {
            boolean result = this.tryHarvest(event.getPlayer(), event.getWorld(), event.getHand(), event.getPos());
            event.setCanceled(result);
            if (result) {
                event.setCancellationResult(event.getWorld().field_72995_K ? ActionResultType.SUCCESS : ActionResultType.CONSUME);
            }
        }
    }

    public boolean tryHarvest(PlayerEntity player, World world, Hand hand, BlockPos pos) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() instanceof HoeItem) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!harvestable.contains(state)) {
                return false;
            }
            Item blockItem = block.func_199767_j();
            BlockState newState = block.func_176223_P();
            if (!world.field_72995_K) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                ServerWorld serverWorld = (ServerWorld)serverPlayer.field_70170_p;
                List drops = Block.func_220077_a((BlockState)state, (ServerWorld)serverWorld, (BlockPos)pos, null, (Entity)player, (ItemStack)ItemStack.field_190927_a);
                for (ItemStack drop : drops) {
                    if (drop.func_77973_b() == blockItem) {
                        drop.func_190918_g(1);
                    }
                    if (drop.func_190926_b()) continue;
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
                }
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)newState));
                world.func_175656_a(pos, newState);
                world.func_184133_a(null, pos, SoundEvents.field_219625_by, SoundCategory.BLOCKS, 1.0f, 1.0f);
                held.func_222118_a(1, (LivingEntity)player, p -> p.func_184609_a(hand));
            }
            return true;
        }
        return false;
    }

    public static void addHarvestable(String blockState) {
        BlockState state;
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(blockState), false).func_197243_a(false);
            state = parser.func_197249_b();
        }
        catch (Exception e) {
            state = null;
        }
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        harvestable.add(state);
    }
}

