/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.PosHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.PlayerStateClient;
import svenhjol.charm.message.ClientUpdatePlayerState;
import svenhjol.charm.message.ServerUpdatePlayerState;

@Module(mod="charm", client=PlayerStateClient.class, description="Synchronize additional state from server to client.", alwaysEnabled=true, hasSubscriptions=true)
public class PlayerState
extends CharmModule {
    public static List<BiConsumer<ServerPlayerEntity, CompoundNBT>> listeners = new ArrayList<BiConsumer<ServerPlayerEntity, CompoundNBT>>();
    @Config(name="Server state update interval", description="Interval (in ticks) on which additional world state will be synchronised to the client.")
    public static int serverStateInverval = 120;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % (long)serverStateInverval == 0L) {
            Charm.PACKET_HANDLER.sendToServer(new ServerUpdatePlayerState());
        }
    }

    public static void serverCallback(ServerPlayerEntity player) {
        ServerWorld world = player.func_71121_q();
        BlockPos pos = player.func_233580_cy_();
        long dayTime = world.func_72820_D() % 24000L;
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("mineshaft", PosHelper.isInsideStructure(world, pos, Structure.field_236367_c_));
        tag.func_74757_a("stronghold", PosHelper.isInsideStructure(world, pos, Structure.field_236375_k_));
        tag.func_74757_a("fortress", PosHelper.isInsideStructure(world, pos, Structure.field_236378_n_));
        tag.func_74757_a("shipwreck", PosHelper.isInsideStructure(world, pos, Structure.field_236373_i_));
        tag.func_74757_a("village", world.func_217483_b_(pos));
        tag.func_74757_a("day", dayTime > 0L && dayTime < 12700L);
        listeners.forEach(action -> action.accept(player, tag));
        Charm.PACKET_HANDLER.sendToPlayer(new ClientUpdatePlayerState(tag), player);
    }
}

