/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.EnchantmentsHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.enchantment.TintedEnchantment;
import svenhjol.charm.module.AnvilImprovements;
import svenhjol.charm.module.Core;

@Module(mod="charm", hasSubscriptions=true, description="When applied, this enchantment lets you change the color of the enchanted glint using dye on an anvil. Requires Core 'Enchantment glint override' to be true.")
public class Tinted
extends CharmModule {
    public static TintedEnchantment TINTED;
    @Config(name="XP cost", description="Number of levels required to change a tinted item using dye on an anvil.")
    public static int xpCost;

    @Override
    public void register() {
        TINTED = new TintedEnchantment(this);
    }

    @Override
    public boolean depends() {
        return Core.overrideGlint;
    }

    @Override
    public void init() {
        if (!ModuleHandler.enabled(AnvilImprovements.class) && xpCost < 1) {
            xpCost = 1;
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!event.isCanceled()) {
            this.handleAnvilBehavior(event);
        }
    }

    public static void applyTint(ItemStack stack, String color) {
        EnchantmentsHelper.apply(stack, TINTED, 1);
        stack.func_196082_o().func_74778_a("charm_glint", color);
    }

    private void handleAnvilBehavior(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        if (!EnchantmentsHelper.has(left, TINTED) || !(right.func_77973_b() instanceof DyeItem)) {
            return;
        }
        int cost = Math.max(0, xpCost);
        ItemStack out = left.func_77946_l();
        DyeItem dye = (DyeItem)right.func_77973_b();
        String color = dye.func_195962_g().func_176610_l();
        Tinted.applyTint(out, color);
        event.setMaterialCost(1);
        event.setCost(cost);
        event.setOutput(out);
    }

    static {
        xpCost = 0;
    }
}

