/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.PotionHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="A witch has a chance to drop a Potion of Luck when killed by a player.", hasSubscriptions=true)
public class WitchesDropLuck
extends CharmModule {
    public static double lootingBoost = 0.25;
    @Config(name="Drop chance", description="Chance (out of 1.0) of a witch dropping a Potion of Luck when killed by the player.")
    public static double dropChance = 0.05;

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled()) {
            this.tryDrop(event.getEntityLiving(), event.getSource(), event.getLootingLevel());
        }
    }

    public void tryDrop(LivingEntity entity, DamageSource damageSource, int lootingLevel) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof WitchEntity && damageSource.func_76346_g() instanceof PlayerEntity && (double)entity.field_70170_p.field_73012_v.nextFloat() <= dropChance + lootingBoost * (double)lootingLevel) {
            BlockPos pos = entity.func_233580_cy_();
            ItemStack potion = PotionHelper.getPotionItemStack(Potions.field_222126_O, 1);
            entity.field_70170_p.func_217376_c((Entity)new ItemEntity(entity.func_130014_f_(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), potion));
        }
    }
}

