/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import svenhjol.charm.Charm;
import svenhjol.charm.base.helper.DataBlockHelper;
import svenhjol.charm.base.helper.LootHelper;
import svenhjol.charm.module.EntitySpawners;

public class EntitySpawnerTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final String ENTITY = "entity";
    private static final String PERSIST = "persist";
    private static final String HEALTH = "health";
    private static final String ARMOR = "armor";
    private static final String EFFECTS = "effects";
    private static final String META = "meta";
    private static final String COUNT = "count";
    private static final String ROTATION = "rotation";
    public ResourceLocation entity = null;
    public Rotation rotation = Rotation.NONE;
    public boolean persist = false;
    public double health = 0.0;
    public String effects = "";
    public String armor = "";
    public int count = 1;
    public String meta = "";

    public EntitySpawnerTileEntity() {
        super(EntitySpawners.TILE_ENTITY);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.entity = ResourceLocation.func_208304_a((String)tag.func_74779_i(ENTITY));
        this.persist = tag.func_74767_n(PERSIST);
        this.health = tag.func_74769_h(HEALTH);
        this.effects = tag.func_74779_i(EFFECTS);
        this.armor = tag.func_74779_i(ARMOR);
        this.count = tag.func_74762_e(COUNT);
        this.meta = tag.func_74779_i(META);
        String rot = tag.func_74779_i(ROTATION);
        this.rotation = rot.isEmpty() ? Rotation.NONE : Rotation.valueOf((String)rot);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74778_a(ENTITY, this.entity.toString());
        tag.func_74778_a(ROTATION, this.rotation.name());
        tag.func_74757_a(PERSIST, this.persist);
        tag.func_74780_a(HEALTH, this.health);
        tag.func_74778_a(EFFECTS, this.effects);
        tag.func_74778_a(ARMOR, this.armor);
        tag.func_74768_a(COUNT, this.count);
        tag.func_74778_a(META, this.meta);
        return tag;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.func_82737_E() % 10L == 0L || this.field_145850_b.func_175659_aa() == Difficulty.PEACEFUL) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(pos).func_186662_g((double)EntitySpawners.triggerDistance));
        if (players.size() == 0) {
            return;
        }
        this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        boolean result = this.trySpawn(pos);
        if (result) {
            Charm.LOG.debug("EntitySpawner spawned entity " + this.entity.toString() + " at pos: " + pos);
        } else {
            Charm.LOG.debug("EntitySpawner failed to spawn entity " + this.entity.toString() + " at pos: " + pos);
        }
    }

    public boolean trySpawn(BlockPos pos) {
        if (this.field_145850_b == null) {
            return false;
        }
        Optional optionalEntityType = Registry.field_212629_r.func_241873_b(this.entity);
        if (!optionalEntityType.isPresent()) {
            return false;
        }
        EntityType type = (EntityType)optionalEntityType.get();
        if (type == EntityType.field_200772_L || type == EntityType.field_200773_M) {
            return this.tryCreateMinecart(type, pos);
        }
        if (type == EntityType.field_200789_c) {
            return this.tryCreateArmorStand(pos);
        }
        for (int i = 0; i < this.count; ++i) {
            Entity spawned = type.func_200721_a(this.field_145850_b);
            if (spawned == null) {
                return false;
            }
            spawned.func_174828_a(pos, 0.0f, 0.0f);
            if (spawned instanceof MobEntity) {
                MobEntity mob = (MobEntity)spawned;
                if (this.persist) {
                    mob.func_110163_bv();
                }
                if (this.health > 0.0) {
                    ModifiableAttributeInstance healthAttribute = mob.func_110148_a(Attributes.field_233818_a_);
                    if (healthAttribute != null) {
                        healthAttribute.func_111128_a(this.health);
                    }
                    mob.func_70606_j((float)this.health);
                }
                if (!this.armor.isEmpty()) {
                    Random random = this.field_145850_b.field_73012_v;
                    this.tryEquip((LivingEntity)mob, this.armor, random);
                }
                ArrayList<String> effectsList = new ArrayList<String>();
                if (this.effects.length() > 0) {
                    if (this.effects.contains(",")) {
                        effectsList.addAll(Arrays.asList(this.effects.split(",")));
                    } else {
                        effectsList.add(this.effects);
                    }
                    if (effectsList.size() > 0) {
                        effectsList.forEach(effectName -> {
                            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectName));
                            if (effect != null) {
                                mob.func_195064_c(new EffectInstance(effect, 999999, 1));
                            }
                        });
                    }
                }
                mob.func_213386_a((IServerWorld)this.field_145850_b, this.field_145850_b.func_175649_E(pos), SpawnReason.TRIGGERED, null, null);
            }
            this.field_145850_b.func_217376_c(spawned);
        }
        return true;
    }

    public boolean tryCreateMinecart(EntityType<?> type, BlockPos pos) {
        ChestMinecartEntity minecart = null;
        if (this.field_145850_b == null) {
            return false;
        }
        if (type == EntityType.field_200773_M) {
            minecart = new ChestMinecartEntity(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            String loot = DataBlockHelper.getValue("loot", this.meta, "");
            ResourceLocation lootTable = LootHelper.getLootTable(loot, LootTables.field_186424_f);
            minecart.func_184289_a(lootTable, this.field_145850_b.field_73012_v.nextLong());
        } else if (type == EntityType.field_200772_L) {
            minecart = new MinecartEntity(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
        if (minecart == null) {
            return false;
        }
        this.field_145850_b.func_217376_c(minecart);
        return true;
    }

    public boolean tryCreateArmorStand(BlockPos pos) {
        if (this.field_145850_b == null) {
            return false;
        }
        Random random = this.field_145850_b.field_73012_v;
        ArmorStandEntity stand = (ArmorStandEntity)EntityType.field_200789_c.func_200721_a(this.field_145850_b);
        if (stand == null) {
            return false;
        }
        Direction face = DataBlockHelper.getFacing(DataBlockHelper.getValue("facing", this.meta, "north"));
        Direction facing = this.rotation.func_185831_a(face);
        String type = DataBlockHelper.getValue("type", this.meta, "");
        this.tryEquip((LivingEntity)stand, type, random);
        float yaw = facing.func_185119_l();
        stand.func_174828_a(pos, yaw, 0.0f);
        this.field_145850_b.func_217376_c((Entity)stand);
        return true;
    }

    private void tryEquip(LivingEntity entity, String type, Random random) {
        ArrayList<Item> ironHeld = new ArrayList<Item>(Arrays.asList(Items.field_151040_l, Items.field_151035_b, Items.field_151036_c));
        ArrayList<Item> goldHeld = new ArrayList<Item>(Arrays.asList(Items.field_151048_u, Items.field_151046_w));
        ArrayList<Item> diamondHeld = new ArrayList<Item>(Arrays.asList(Items.field_151048_u, Items.field_151046_w, Items.field_151056_x, Items.field_151047_v));
        if (type.equals("leather")) {
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ironHeld.get(random.nextInt(ironHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151024_Q));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151027_R));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151026_S));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151021_T));
            }
        }
        if (type.equals("chain")) {
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ironHeld.get(random.nextInt(ironHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151020_U));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151023_V));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151022_W));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151029_X));
            }
        }
        if (type.equals("iron")) {
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ironHeld.get(random.nextInt(ironHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151028_Y));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151030_Z));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151165_aa));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151167_ab));
            }
        }
        if (type.equals("gold")) {
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)goldHeld.get(random.nextInt(goldHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151169_ag));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151171_ah));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151149_ai));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151151_aj));
            }
        }
        if (type.equals("diamond")) {
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)diamondHeld.get(random.nextInt(diamondHeld.size()))));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151161_ac));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151163_ad));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151173_ae));
            }
            if (random.nextFloat() < 0.25f) {
                entity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151175_af));
            }
        }
    }
}

