/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.capabilities;

import com.inventorypets.handler.ItemStackHandlerDoubleChest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityProviderDoubleChest
implements ICapabilitySerializable<INBT> {
    private final Direction NO_SPECIFIC_SIDE = null;
    private static final int MAX_NUMBER_OF_ITEMS_IN_CHEST = 54;
    private ItemStackHandlerDoubleChest itemStackHandlerDoubleChest;
    private final LazyOptional<IItemHandler> lazyInitialisionSupplier = LazyOptional.of(this::getCachedInventory);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability) {
            return this.lazyInitialisionSupplier;
        }
        return LazyOptional.empty();
    }

    public INBT serializeNBT() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.getCachedInventory(), this.NO_SPECIFIC_SIDE);
    }

    public void deserializeNBT(INBT nbt) {
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.getCachedInventory(), this.NO_SPECIFIC_SIDE, nbt);
    }

    private ItemStackHandlerDoubleChest getCachedInventory() {
        if (this.itemStackHandlerDoubleChest == null) {
            this.itemStackHandlerDoubleChest = new ItemStackHandlerDoubleChest(54);
        }
        return this.itemStackHandlerDoubleChest;
    }
}

