/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.InventoryPets;
import com.inventorypets.helper.ProxyHelper;
import com.inventorypets.init.ModSoundEvents;
import java.util.EnumSet;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MiniQuantumBlazeEntity
extends MonsterEntity {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(MiniQuantumBlazeEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int miniCount = 1800;

    public MiniQuantumBlazeEntity(EntityType<? extends MiniQuantumBlazeEntity> p_i50215_1_, World p_i50215_2_) {
        super(p_i50215_1_, p_i50215_2_);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new FireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.mqbbreathe;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSoundEvents.mqbhit;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.mqbdeath;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public boolean func_70652_k(Entity par1Entity) {
        return par1Entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 6.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    public float getBrightness(float par1) {
        return 2.0f;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity entityplayer = this.field_70170_p.func_217362_a((Entity)this, 100.0);
            if (entityplayer != null) {
                if (Math.abs(entityplayer.field_70142_S - this.field_70142_S) + Math.abs(entityplayer.field_70137_T - this.field_70137_T) + Math.abs(entityplayer.field_70136_U - this.field_70136_U) >= 24.0) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(entityplayer.field_70142_S - this.field_70142_S, entityplayer.field_70137_T - this.field_70137_T, entityplayer.field_70136_U - this.field_70136_U));
                }
                if (entityplayer.func_110144_aD() != null) {
                    this.func_70624_b(entityplayer.func_110144_aD());
                } else if (entityplayer.func_110144_aD() == null) {
                    this.func_70624_b(entityplayer.func_70643_av());
                }
            } else {
                this.func_70106_y();
            }
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = -0.5f + (float)this.field_70146_Z.nextGaussian() * 2.0f;
            }
            if (this.func_70638_az() != null && this.func_70638_az().field_70137_T + (double)this.func_70638_az().func_70047_e() > this.field_70137_T + (double)this.func_70047_e() + (double)this.heightOffset) {
                double getX = this.func_213322_ci().field_72450_a;
                double getY = this.func_213322_ci().field_72448_b;
                double getZ = this.func_213322_ci().field_72449_c;
                this.func_213293_j(getX, getY += ((double)0.3f - this.func_213322_ci().field_72448_b) * (double)0.3f, getZ);
            }
        }
        if (this.field_70146_Z.nextInt(24) == 0) {
            // empty if block
        }
        if (this.field_70170_p.field_72995_K) {
            ProxyHelper.spawnPortalEffects2(this.field_70170_p, (int)this.field_70142_S, (int)this.field_70137_T, (int)this.field_70136_U);
        }
        --this.miniCount;
        if (this.miniCount <= 0) {
            this.field_70170_p.func_184148_a(null, this.field_70142_S, this.field_70137_T, this.field_70136_U, ModSoundEvents.mqbdeath, SoundCategory.PLAYERS, 0.5f, 1.0f);
            this.func_70106_y();
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        LivingEntity livingentity;
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((livingentity = this.func_70638_az()) != null && livingentity.func_226280_cw_() > this.func_226280_cw_() + (double)this.heightOffset && this.func_213336_c(livingentity)) {
            Vector3d vec3d = this.func_213322_ci();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vec3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70027_ad() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    private void setOnFire(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        b0 = onFire ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)b0);
    }

    protected void fall(float par1) {
    }

    protected Item getDropItem() {
        return Items.field_191525_da;
    }

    protected void dropFewItems(boolean par1, int par2) {
        int h = this.field_70146_Z.nextInt(100);
        if (h >= 2 && h <= 20) {
            this.func_199702_a((IItemProvider)InventoryPets.NUGGET_COAL.get(), 1);
        } else if (h == 1) {
            this.func_199702_a((IItemProvider)InventoryPets.NUGGET_DIAMOND.get(), 1);
        }
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    static class FireballAttackGoal
    extends Goal {
        private final MiniQuantumBlazeEntity blaze;
        private int attackStep;
        private int attackTime;
        private int field_223527_d;

        public FireballAttackGoal(MiniQuantumBlazeEntity blazeIn) {
            this.blaze = blazeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.blaze.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.blaze.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.blaze.setOnFire(false);
            this.field_223527_d = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.blaze.func_70638_az();
            if (livingentity != null) {
                boolean flag = this.blaze.func_70635_at().func_75522_a((Entity)livingentity);
                this.field_223527_d = flag ? 0 : ++this.field_223527_d;
                double d0 = this.blaze.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blaze.func_70652_k((Entity)livingentity);
                    }
                    this.blaze.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.blaze.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.blaze.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.blaze.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            this.blaze.setOnFire(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.blaze.setOnFire(false);
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            this.blaze.field_70170_p.func_217378_a((PlayerEntity)null, 1018, this.blaze.func_233580_cy_(), 0);
                            for (int i = 0; i < 1; ++i) {
                                SmallFireballEntity smallfireballentity = new SmallFireballEntity(this.blaze.field_70170_p, (LivingEntity)this.blaze, d1 + this.blaze.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.blaze.func_70681_au().nextGaussian() * (double)f);
                                smallfireballentity.func_70107_b(smallfireballentity.func_226277_ct_(), this.blaze.func_226283_e_(0.5) + 0.5, smallfireballentity.func_226281_cx_());
                                this.blaze.field_70170_p.func_217376_c((Entity)smallfireballentity);
                            }
                        }
                    }
                    this.blaze.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.field_223527_d < 5) {
                    this.blaze.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.blaze.func_110148_a(Attributes.field_233819_b_).func_111126_e();
        }
    }
}

