/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SiamesePetEntity
extends CatEntity {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});
    public static final Map<Integer, ResourceLocation> field_213425_bD = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_213410_0_ -> p_213410_0_.put(10, new ResourceLocation("textures/entity/cat/siamese.png")));
    private AvoidPlayerGoal<PlayerEntity> avoidPlayerGoal;
    private net.minecraft.entity.ai.goal.TemptGoal temptGoal;

    public SiamesePetEntity(EntityType<? extends SiamesePetEntity> entitySiamesePet, World worldIn) {
        super(entitySiamesePet, worldIn);
    }

    protected void func_184651_r() {
        this.temptGoal = new TemptGoal(this, 0.6, BREEDING_ITEMS, true);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MorningGiftGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)this.temptGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new CatLieOnBedGoal((CatEntity)this, 1.1, 8));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new CatSitOnBlockGoal((CatEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(9, (Goal)new OcelotAttackGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(11, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NonTamedTargetGoal((TameableEntity)this, RabbitEntity.class, false, (Predicate)((com.google.common.base.Predicate)null)));
        this.field_70715_bh.func_75776_a(1, (Goal)new NonTamedTargetGoal((TameableEntity)this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
    }

    protected void func_175544_ck() {
        if (this.avoidPlayerGoal == null) {
            this.avoidPlayerGoal = new AvoidPlayerGoal<PlayerEntity>(this, PlayerEntity.class, 16.0f, 0.8, 1.33);
        }
        this.field_70714_bg.func_85156_a(this.avoidPlayerGoal);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, this.avoidPlayerGoal);
        }
    }

    static class TemptGoal
    extends net.minecraft.entity.ai.goal.TemptGoal {
        @Nullable
        private PlayerEntity temptingPlayer;
        private final CatEntity cat;

        public TemptGoal(CatEntity catIn, double speedIn, Ingredient temptItemsIn, boolean p_i50438_5_) {
            super((CreatureEntity)catIn, speedIn, temptItemsIn, p_i50438_5_);
            this.cat = catIn;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.temptingPlayer == null && this.field_75284_a.func_70681_au().nextInt(600) == 0) {
                this.temptingPlayer = this.field_75289_h;
            } else if (this.field_75284_a.func_70681_au().nextInt(500) == 0) {
                this.temptingPlayer = null;
            }
        }

        protected boolean func_220761_g() {
            return this.temptingPlayer != null && this.temptingPlayer.equals((Object)this.field_75289_h) ? false : super.func_220761_g();
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.cat.func_70909_n();
        }
    }

    static class MorningGiftGoal
    extends Goal {
        private final CatEntity cat;
        private PlayerEntity owner;
        private BlockPos bedPos;
        private int tickCounter;

        public MorningGiftGoal(CatEntity catIn) {
            this.cat = catIn;
        }

        public boolean func_75250_a() {
            if (!this.cat.func_70909_n()) {
                return false;
            }
            if (this.cat.func_233685_eM_()) {
                return false;
            }
            LivingEntity livingentity = this.cat.func_70902_q();
            if (livingentity instanceof PlayerEntity) {
                this.owner = (PlayerEntity)livingentity;
                if (!livingentity.func_70608_bn()) {
                    return false;
                }
                if (this.cat.func_70068_e((Entity)this.owner) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.owner.func_233580_cy_();
                BlockState blockstate = this.cat.field_70170_p.func_180495_p(blockpos);
                if (blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
                    Direction direction = (Direction)blockstate.func_177229_b((Property)HorizontalBlock.field_185512_D);
                    this.bedPos = new BlockPos(blockpos.func_177958_n() - direction.func_82601_c(), blockpos.func_177956_o(), blockpos.func_177952_p() - direction.func_82599_e());
                    return !this.func_220805_g();
                }
            }
            return false;
        }

        private boolean func_220805_g() {
            for (CatEntity catentity : this.cat.field_70170_p.func_217357_a(CatEntity.class, new AxisAlignedBB(this.bedPos).func_186662_g(2.0))) {
                if (catentity == this.cat || !catentity.func_213416_eg() && !catentity.func_213409_eh()) continue;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.cat.func_70909_n() && !this.cat.func_233685_eM_() && this.owner != null && this.owner.func_70608_bn() && this.bedPos != null && !this.func_220805_g();
        }

        public void func_75249_e() {
            if (this.bedPos != null) {
                this.cat.func_233686_v_(false);
                this.cat.func_70661_as().func_75492_a((double)this.bedPos.func_177958_n(), (double)this.bedPos.func_177956_o(), (double)this.bedPos.func_177952_p(), (double)1.1f);
            }
        }

        public void func_75251_c() {
            this.cat.func_213419_u(false);
            float f = this.cat.field_70170_p.func_72929_e(1.0f);
            if (this.owner.func_71060_bI() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.field_70170_p.func_201674_k().nextFloat() < 0.7) {
                this.func_220804_h();
            }
            this.tickCounter = 0;
            this.cat.func_213415_v(false);
            this.cat.func_70661_as().func_75499_g();
        }

        private void func_220804_h() {
            Random random = this.cat.func_70681_au();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            blockpos$mutable.func_189533_g((Vector3i)this.cat.func_233580_cy_());
            this.cat.func_213373_a((double)(blockpos$mutable.func_177958_n() + random.nextInt(11) - 5), (double)(blockpos$mutable.func_177956_o() + random.nextInt(5) - 2), (double)(blockpos$mutable.func_177952_p() + random.nextInt(11) - 5), false);
            blockpos$mutable.func_189533_g((Vector3i)this.cat.func_233580_cy_());
            LootTable loottable = this.cat.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_215797_af);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.cat.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.cat.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this.cat).func_216023_a(random);
            for (ItemStack itemstack : loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216264_e))) {
                this.cat.field_70170_p.func_217376_c((Entity)new ItemEntity(this.cat.field_70170_p, (double)blockpos$mutable.func_177958_n() - (double)MathHelper.func_76126_a((float)(this.cat.field_70761_aq * ((float)Math.PI / 180))), (double)blockpos$mutable.func_177956_o(), (double)blockpos$mutable.func_177952_p() + (double)MathHelper.func_76134_b((float)(this.cat.field_70761_aq * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void func_75246_d() {
            if (this.owner != null && this.bedPos != null) {
                this.cat.func_233686_v_(false);
                this.cat.func_70661_as().func_75492_a((double)this.bedPos.func_177958_n(), (double)this.bedPos.func_177956_o(), (double)this.bedPos.func_177952_p(), (double)1.1f);
                if (this.cat.func_70068_e((Entity)this.owner) < 2.5) {
                    ++this.tickCounter;
                    if (this.tickCounter > 16) {
                        this.cat.func_213419_u(true);
                        this.cat.func_213415_v(false);
                    } else {
                        this.cat.func_70625_a((Entity)this.owner, 45.0f, 45.0f);
                        this.cat.func_213415_v(true);
                    }
                } else {
                    this.cat.func_213419_u(false);
                }
            }
        }
    }

    static class AvoidPlayerGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final CatEntity field_220873_i;

        public AvoidPlayerGoal(CatEntity p_i50440_1_, Class<T> p_i50440_2_, float p_i50440_3_, double p_i50440_4_, double p_i50440_6_) {
            super((CreatureEntity)p_i50440_1_, p_i50440_2_, p_i50440_3_, p_i50440_4_, p_i50440_6_, EntityPredicates.field_188444_d::test);
            this.field_220873_i = p_i50440_1_;
        }

        public boolean func_75250_a() {
            return !this.field_220873_i.func_70909_n() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.field_220873_i.func_70909_n() && super.func_75253_b();
        }
    }
}

