/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.events;

import com.inventorypets.InventoryPets;
import com.inventorypets.config.InventoryPetsConfig;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="inventorypets", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CobbleDirtAchieveHandler {
    @SubscribeEvent
    public void notifyAttack(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity entityplayer = (PlayerEntity)event.getEntityLiving();
            World world = entityplayer.field_70170_p;
            if (!entityplayer.field_70170_p.field_72995_K) {
                boolean hasCobble = false;
                boolean hasDirt = false;
                for (int i = 0; i <= PlayerInventory.func_70451_h() - 1; ++i) {
                    ItemStack itemchk = entityplayer.field_71071_by.func_70301_a(i);
                    if (itemchk != ItemStack.field_190927_a && !InventoryPetsConfig.disableCobblestone && itemchk.func_77973_b() == InventoryPets.PET_COBBLESTONE.get()) {
                        hasCobble = true;
                        continue;
                    }
                    if (itemchk == ItemStack.field_190927_a || InventoryPetsConfig.disableDirt || itemchk.func_77973_b() != InventoryPets.PET_DIRT.get()) continue;
                    hasDirt = true;
                }
                if (hasCobble || hasDirt) {
                    AxisAlignedBB range = new AxisAlignedBB(entityplayer.func_226277_ct_() - 48.0, entityplayer.func_226278_cu_() - 48.0, entityplayer.func_226281_cx_() - 48.0, entityplayer.func_226277_ct_() + 48.0, entityplayer.func_226278_cu_() + 48.0, entityplayer.func_226281_cx_() + 48.0);
                    List entities = world.func_175674_a((Entity)entityplayer, range, null);
                    int esize = entities.size();
                    for (int k = 0; k <= esize - 1; ++k) {
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(entity instanceof ServerPlayerEntity) || entity == entityplayer) continue;
                        double xt = entity.field_70142_S;
                        double yt = entity.field_70137_T;
                        double zt = entity.field_70136_U;
                        int x1 = MathHelper.func_76128_c((double)entityplayer.field_70142_S);
                        int y1 = MathHelper.func_76128_c((double)entityplayer.field_70137_T);
                        int z1 = MathHelper.func_76128_c((double)entityplayer.field_70136_U);
                        double x2 = xt - (double)x1;
                        double y2 = yt - (double)y1;
                        double z2 = zt - (double)z1;
                        ServerPlayerEntity killingEntity = (ServerPlayerEntity)entity;
                        if (MathHelper.func_76130_a((int)((int)x2)) >= 48 || MathHelper.func_76130_a((int)((int)z2)) >= 48 || MathHelper.func_76130_a((int)((int)y2)) >= 48) continue;
                        if (hasCobble && !CobbleDirtAchieveHandler.hasAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_cobble"))) {
                            CobbleDirtAchieveHandler.unlockAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_cobble"));
                        }
                        if (!hasDirt || CobbleDirtAchieveHandler.hasAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_dirt"))) continue;
                        CobbleDirtAchieveHandler.unlockAdvancement(killingEntity, new ResourceLocation("inventorypets", "kill_dirt"));
                    }
                }
            }
        }
    }

    public static boolean hasAdvancement(ServerPlayerEntity playerMP, ResourceLocation location) {
        Advancement advancement = null;
        MinecraftServer server = playerMP.func_184102_h();
        try {
            advancement = server.func_191949_aK().func_192778_a(location);
            AdvancementProgress advancementprogress = playerMP.func_192039_O().func_192747_a(advancement);
            if (advancementprogress.func_192105_a()) {
                return true;
            }
        }
        catch (CommandException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void unlockAdvancement(ServerPlayerEntity player, ResourceLocation location) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        MinecraftServer server = player.func_184102_h();
        try {
            ServerPlayerEntity playerMP = player;
            Advancement advancement = server.func_191949_aK().func_192778_a(location);
            AdvancementProgress advancementprogress = playerMP.func_192039_O().func_192747_a(advancement);
            if (advancementprogress.func_192105_a()) {
                return;
            }
            for (String s : advancementprogress.func_192107_d()) {
                playerMP.func_192039_O().func_192750_a(advancement, s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

