/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.items;

import com.inventorypets.capabilities.CapabilityProviderFeedBag;
import com.inventorypets.container.ContainerFeedBag;
import com.inventorypets.handler.ItemStackHandlerFeedBag;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class feedBag
extends Item {
    private final String BASE_NBT_TAG = "base";
    private final String CAPABILITY_NBT_TAG = "cap";
    private static final Logger LOGGER = LogManager.getLogger();

    public feedBag() {
        super(new Item.Properties().func_200917_a(1));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ContainerProviderFeedBag containerProviderFeedBag = new ContainerProviderFeedBag(this, stack);
            int NUMBER_OF_BAG_SLOTS = 18;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProviderFeedBag, packetBuffer -> packetBuffer.writeInt(18));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Nonnull
    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        IItemHandler tileInventory;
        World world = ctx.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.PASS;
        }
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        ItemStack itemStack = ctx.func_195996_i();
        if (!(itemStack.func_77973_b() instanceof feedBag)) {
            throw new AssertionError((Object)"Unexpected itemFeedBag type");
        }
        feedBag itemFeedBag = (feedBag)itemStack.func_77973_b();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return ActionResultType.PASS;
        }
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (capability.isPresent()) {
            tileInventory = (IItemHandler)capability.orElseThrow(AssertionError::new);
        } else if (tileEntity instanceof IInventory) {
            tileInventory = new InvWrapper((IInventory)tileEntity);
        } else {
            return ActionResultType.FAIL;
        }
        ItemStackHandlerFeedBag itemStackHandlerFeedBag = feedBag.getItemStackHandlerFeedBag(itemStack);
        for (int i = 0; i < itemStackHandlerFeedBag.getSlots(); ++i) {
            ItemStack invStack = itemStackHandlerFeedBag.getStackInSlot(i);
            ItemStack invStacksWhichDidNotFit = ItemHandlerHelper.insertItemStacked((IItemHandler)tileInventory, (ItemStack)invStack, (boolean)false);
            itemStackHandlerFeedBag.setStackInSlot(i, invStacksWhichDidNotFit);
        }
        tileEntity.func_70296_d();
        CompoundNBT nbt = itemStack.func_196082_o();
        int dirtyCounter = nbt.func_74762_e("dirtyCounter");
        nbt.func_74768_a("dirtyCounter", dirtyCounter + 1);
        itemStack.func_77982_d(nbt);
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT oldCapNbt) {
        return new CapabilityProviderFeedBag();
    }

    public static ItemStackHandlerFeedBag getItemStackHandlerFeedBag(ItemStack itemStack) {
        IItemHandler feedBag2 = (IItemHandler)itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (feedBag2 == null || !(feedBag2 instanceof ItemStackHandlerFeedBag)) {
            LOGGER.error("ItemFeedBag did not have the expected ITEM_HANDLER_CAPABILITY");
            return new ItemStackHandlerFeedBag(1);
        }
        return (ItemStackHandlerFeedBag)feedBag2;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT baseTag = stack.func_77978_p();
        ItemStackHandlerFeedBag itemStackHandlerFeedBag = feedBag.getItemStackHandlerFeedBag(stack);
        CompoundNBT capabilityTag = itemStackHandlerFeedBag.serializeNBT();
        CompoundNBT combinedTag = new CompoundNBT();
        if (baseTag != null) {
            combinedTag.func_218657_a("base", (INBT)baseTag);
        }
        if (capabilityTag != null) {
            combinedTag.func_218657_a("cap", (INBT)capabilityTag);
        }
        return combinedTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null) {
            stack.func_77982_d(null);
            return;
        }
        CompoundNBT baseTag = nbt.func_74775_l("base");
        CompoundNBT capabilityTag = nbt.func_74775_l("cap");
        stack.func_77982_d(baseTag);
        ItemStackHandlerFeedBag itemStackHandlerFeedBag = feedBag.getItemStackHandlerFeedBag(stack);
        itemStackHandlerFeedBag.deserializeNBT(capabilityTag);
    }

    private static float getFullnessPropertyOverride(ItemStack itemStack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        ItemStackHandlerFeedBag feedBag2 = feedBag.getItemStackHandlerFeedBag(itemStack);
        float fractionEmpty = (float)feedBag2.getNumberOfEmptySlots() / (float)feedBag2.getSlots();
        return 1.0f - fractionEmpty;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        list.add((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.ip.petchestopen", (Object[])new Object[0]) + TextFormatting.DARK_GREEN + " [" + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tooltip.ip.rightclick", (Object[])new Object[0]) + TextFormatting.DARK_GREEN + "]"));
        list.add((ITextComponent)new TranslationTextComponent(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.ip.legacy", (Object[])new Object[0])));
    }

    private static class ContainerProviderFeedBag
    implements INamedContainerProvider {
        private feedBag itemFeedBag;
        private ItemStack itemStackFeedBag;

        public ContainerProviderFeedBag(feedBag itemFeedBag, ItemStack itemStackFeedBag) {
            this.itemStackFeedBag = itemStackFeedBag;
            this.itemFeedBag = itemFeedBag;
        }

        public ITextComponent func_145748_c_() {
            return this.itemStackFeedBag.func_200301_q();
        }

        public ContainerFeedBag createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            ContainerFeedBag newContainerServerSide = ContainerFeedBag.createContainerServerSide(windowID, playerInventory, feedBag.getItemStackHandlerFeedBag(this.itemStackFeedBag), this.itemStackFeedBag);
            playerEntity.field_70170_p.func_184148_a(null, playerEntity.field_70142_S, playerEntity.field_70137_T, playerEntity.field_70136_U, SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 0.7f);
            return newContainerServerSide;
        }
    }
}

