/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimingData;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistoryEntry;
import co.aikar.timings.TimingsManager;
import co.aikar.util.JSONUtil;
import co.aikar.util.LoadingMap;
import co.aikar.util.MRUMapCache;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimingHistory {
    public static long lastMinuteTime;
    public static long timedTicks;
    public static long playerTicks;
    public static long entityTicks;
    public static long tileEntityTicks;
    public static long activatedEntityTicks;
    private static int worldIdPool;
    static Map<String, Integer> worldMap;
    private final long endTime;
    private final long startTime;
    private final long totalTicks;
    private final long totalTime;
    private final MinuteReport[] minuteReports;
    private final TimingHistoryEntry[] entries;
    final Set<Material> tileEntityTypeSet = Sets.newHashSet();
    final Set<EntityType> entityTypeSet = Sets.newHashSet();
    private final Map<Object, Object> worlds;

    TimingHistory() {
        this.endTime = System.currentTimeMillis() / 1000L;
        this.startTime = TimingsManager.historyStart / 1000L;
        if (timedTicks % 1200L != 0L || TimingsManager.MINUTE_REPORTS.isEmpty()) {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size() + 1]);
            this.minuteReports[this.minuteReports.length - 1] = new MinuteReport();
        } else {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size()]);
        }
        long ticks = 0L;
        for (MinuteReport mp : this.minuteReports) {
            ticks += mp.ticksRecord.timed;
        }
        this.totalTicks = ticks;
        this.totalTime = TimingsManager.FULL_SERVER_TICK.record.getTotalTime();
        this.entries = new TimingHistoryEntry[TimingsManager.HANDLERS.size()];
        int i = 0;
        for (TimingHandler handler : TimingsManager.HANDLERS) {
            this.entries[i++] = new TimingHistoryEntry(handler);
        }
        this.worlds = JSONUtil.toObjectMapper(Bukkit.getWorlds(), new Function<World, JSONUtil.JSONPair>(){

            @NotNull
            public JSONUtil.JSONPair apply(World world) {
                Map<RegionData.RegionId, RegionData> regions = LoadingMap.newHashMap(RegionData.LOADER);
                for (Chunk chunk : world.getLoadedChunks()) {
                    RegionData data = regions.get(new RegionData.RegionId(chunk.getX(), chunk.getZ()));
                    for (Entity entity : chunk.getEntities()) {
                        if (entity == null) {
                            Bukkit.getLogger().warning("Null entity detected in chunk at position x: " + chunk.getX() + ", z: " + chunk.getZ());
                            continue;
                        }
                        data.entityCounts.get(entity.getType()).increment();
                    }
                    for (Metadatable metadatable : chunk.getTileEntities()) {
                        if (metadatable == null) {
                            Bukkit.getLogger().warning("Null tileentity detected in chunk at position x: " + chunk.getX() + ", z: " + chunk.getZ());
                            continue;
                        }
                        data.tileEntityCounts.get(metadatable.getBlock().getType()).increment();
                    }
                }
                return JSONUtil.pair(worldMap.get(world.getName()).intValue(), (Object)JSONUtil.toArrayMapper(regions.values(), new Function<RegionData, Object>(){

                    @NotNull
                    public Object apply(RegionData input) {
                        return JSONUtil.toArray(input.regionId.x, input.regionId.z, JSONUtil.toObjectMapper(input.entityCounts.entrySet(), new Function<Map.Entry<EntityType, Counter>, JSONUtil.JSONPair>(){

                            @NotNull
                            public JSONUtil.JSONPair apply(Map.Entry<EntityType, Counter> entry) {
                                TimingHistory.this.entityTypeSet.add(entry.getKey());
                                return JSONUtil.pair(String.valueOf(entry.getKey().ordinal()), (Object)entry.getValue().count());
                            }
                        }), JSONUtil.toObjectMapper(input.tileEntityCounts.entrySet(), new Function<Map.Entry<Material, Counter>, JSONUtil.JSONPair>(){

                            @NotNull
                            public JSONUtil.JSONPair apply(Map.Entry<Material, Counter> entry) {
                                TimingHistory.this.tileEntityTypeSet.add(entry.getKey());
                                return JSONUtil.pair(String.valueOf(entry.getKey().ordinal()), (Object)entry.getValue().count());
                            }
                        }));
                    }
                }));
            }
        });
    }

    static void resetTicks(boolean fullReset) {
        if (fullReset) {
            timedTicks = 0L;
        }
        lastMinuteTime = System.nanoTime();
        playerTicks = 0L;
        tileEntityTicks = 0L;
        entityTicks = 0L;
        activatedEntityTicks = 0L;
    }

    @NotNull
    Object export() {
        return JSONUtil.createObject(JSONUtil.pair("s", (Object)this.startTime), JSONUtil.pair("e", (Object)this.endTime), JSONUtil.pair("tk", (Object)this.totalTicks), JSONUtil.pair("tm", (Object)this.totalTime), JSONUtil.pair("w", this.worlds), JSONUtil.pair("h", (Object)JSONUtil.toArrayMapper(this.entries, new Function<TimingHistoryEntry, Object>(){

            @Nullable
            public Object apply(TimingHistoryEntry entry) {
                TimingData record = entry.data;
                if (!record.hasData()) {
                    return null;
                }
                return entry.export();
            }
        })), JSONUtil.pair("mp", (Object)JSONUtil.toArrayMapper(this.minuteReports, new Function<MinuteReport, Object>(){

            @NotNull
            public Object apply(MinuteReport input) {
                return input.export();
            }
        })));
    }

    static {
        worldIdPool = 1;
        worldMap = LoadingMap.newHashMap(new Function<String, Integer>(){

            @NotNull
            public Integer apply(@Nullable String input) {
                return worldIdPool++;
            }
        });
    }

    private static class Counter {
        private int count = 0;

        private Counter() {
        }

        public int increment() {
            return ++this.count;
        }

        public int count() {
            return this.count;
        }
    }

    private static class PingRecord {
        final double avg;

        PingRecord() {
            Collection<? extends Player> onlinePlayers = Bukkit.getOnlinePlayers();
            int totalPing = 0;
            for (Player player : onlinePlayers) {
                totalPing += player.spigot().getPing();
            }
            this.avg = onlinePlayers.isEmpty() ? 0.0 : (double)(totalPing / onlinePlayers.size());
        }
    }

    private static class TicksRecord {
        final long timed = timedTicks - (long)(TimingsManager.MINUTE_REPORTS.size() * 1200);
        final long player = playerTicks;
        final long entity = entityTicks;
        final long tileEntity = tileEntityTicks;
        final long activatedEntity = activatedEntityTicks;

        TicksRecord() {
        }
    }

    static class MinuteReport {
        final long time = System.currentTimeMillis() / 1000L;
        final TicksRecord ticksRecord = new TicksRecord();
        final PingRecord pingRecord = new PingRecord();
        final TimingData fst;
        final double tps;
        final double usedMemory;
        final double freeMemory;
        final double loadAvg;

        MinuteReport() {
            this.fst = TimingsManager.FULL_SERVER_TICK.minuteData.clone();
            this.tps = 1.0E9 / (double)(System.nanoTime() - lastMinuteTime) * (double)this.ticksRecord.timed;
            this.usedMemory = TimingsManager.FULL_SERVER_TICK.avgUsedMemory;
            this.freeMemory = TimingsManager.FULL_SERVER_TICK.avgFreeMemory;
            this.loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }

        @NotNull
        List<Object> export() {
            return JSONUtil.toArray(this.time, (double)Math.round(this.tps * 100.0) / 100.0, (double)Math.round(this.pingRecord.avg * 100.0) / 100.0, this.fst.export(), JSONUtil.toArray(this.ticksRecord.timed, this.ticksRecord.player, this.ticksRecord.entity, this.ticksRecord.activatedEntity, this.ticksRecord.tileEntity), this.usedMemory, this.freeMemory, this.loadAvg);
        }
    }

    static class RegionData {
        final RegionId regionId;
        static Function<RegionId, RegionData> LOADER = new Function<RegionId, RegionData>(){

            @NotNull
            public RegionData apply(@NotNull RegionId id) {
                return new RegionData(id);
            }
        };
        final Map<EntityType, Counter> entityCounts = MRUMapCache.of(LoadingMap.of(new EnumMap(EntityType.class), k -> new Counter()));
        final Map<Material, Counter> tileEntityCounts = MRUMapCache.of(LoadingMap.of(new EnumMap(Material.class), k -> new Counter()));

        RegionData(@NotNull RegionId id) {
            this.regionId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionData that = (RegionData)o;
            return this.regionId.equals(that.regionId);
        }

        public int hashCode() {
            return this.regionId.hashCode();
        }

        static class RegionId {
            final int x;
            final int z;
            final long regionId;

            RegionId(int x, int z) {
                this.x = x >> 5 << 5;
                this.z = z >> 5 << 5;
                this.regionId = ((long)this.x << 32) + (long)(this.z >> 5 << 5) - Integer.MIN_VALUE;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RegionId regionId1 = (RegionId)o;
                return this.regionId == regionId1.regionId;
            }

            public int hashCode() {
                return (int)(this.regionId ^ this.regionId >>> 32);
            }
        }
    }
}

