/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.config.PaperConfig;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;

public class PaperCommand
extends Command {
    private static final String BASE_PERM = "bukkit.command.paper.";
    private static final ImmutableSet<String> SUBCOMMANDS = ImmutableSet.builder().add((Object[])new String[]{"heap", "entity", "reload", "version"}).build();

    public PaperCommand(String name) {
        super(name);
        this.description = "Paper related commands";
        this.usageMessage = "/paper [" + Joiner.on((String)" | ").join(SUBCOMMANDS) + "]";
        this.setPermission("bukkit.command.paper;" + Joiner.on((char)';').join((Iterable)SUBCOMMANDS.stream().map(s -> BASE_PERM + s).collect(Collectors.toSet())));
    }

    private static boolean testPermission(CommandSender commandSender, String permission) {
        if (commandSender.hasPermission(BASE_PERM + permission) || commandSender.hasPermission("bukkit.command.paper")) {
            return true;
        }
        commandSender.sendMessage(Bukkit.getPermissionMessage());
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        if (args.length <= 1) {
            return PaperCommand.getListMatchingLast(sender, args, SUBCOMMANDS);
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                if (args.length == 2) {
                    return PaperCommand.getListMatchingLast(sender, args, "help", "list");
                }
                if (args.length != 3) break;
                return PaperCommand.getListMatchingLast(sender, args, (String[])EntityType.getEntityNameList().stream().map(ResourceLocation::toString).sorted().toArray(String[]::new));
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] args, String ... matches) {
        return PaperCommand.getListMatchingLast(sender, args, Arrays.asList(matches));
    }

    public static boolean matches(String s, String s1) {
        return s1.regionMatches(true, 0, s, 0, s.length());
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] strings, Collection<?> collection) {
        String last = strings[strings.length - 1];
        ArrayList results = Lists.newArrayList();
        if (!collection.isEmpty()) {
            for (String s1 : Iterables.transform(collection, (Function)Functions.toStringFunction())) {
                if (!PaperCommand.matches(last, s1) || !sender.hasPermission(BASE_PERM + s1) && !sender.hasPermission("bukkit.command.paper")) continue;
                results.add(s1);
            }
            if (results.isEmpty()) {
                for (Object object : collection) {
                    if (!(object instanceof ResourceLocation) || !PaperCommand.matches(last, ((ResourceLocation)object).func_110623_a())) continue;
                    results.add(String.valueOf(object));
                }
            }
        }
        return results;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        if (SUBCOMMANDS.contains((Object)args[0].toLowerCase(Locale.ENGLISH)) && !PaperCommand.testPermission(sender, args[0].toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "heap": {
                this.dumpHeap(sender);
                break;
            }
            case "entity": {
                this.listEntities(sender, args);
                break;
            }
            case "reload": {
                this.doReload(sender);
                break;
            }
            case "ver": {
                if (!PaperCommand.testPermission(sender, "version")) break;
            }
            case "version": {
                Command ver = Bukkit.getServer().getCommandMap().getCommand("version");
                if (ver != null) {
                    ver.execute(sender, commandLabel, new String[0]);
                    break;
                }
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private void listEntities(CommandSender sender, String[] args) {
        if (args.length < 2 || args[1].toLowerCase(Locale.ENGLISH).equals("help")) {
            sender.sendMessage(ChatColor.RED + "Use /paper entity [list] help for more information on a specific command.");
            return;
        }
        switch (args[1].toLowerCase(Locale.ENGLISH)) {
            case "list": {
                String worldName;
                String filter = "*";
                if (args.length > 2) {
                    if (args[2].toLowerCase(Locale.ENGLISH).equals("help")) {
                        sender.sendMessage(ChatColor.RED + "Use /paper entity list [filter] [worldName] to get entity info that matches the optional filter.");
                        return;
                    }
                    filter = args[2];
                }
                String cleanfilter = filter.replace("?", ".?").replace("*", ".*?");
                Set names = EntityType.getEntityNameList().stream().filter(n -> n.toString().matches(cleanfilter)).collect(Collectors.toSet());
                if (names.isEmpty()) {
                    sender.sendMessage(ChatColor.RED + "Invalid filter, does not match any entities. Use /paper entity list for a proper list");
                    sender.sendMessage(ChatColor.RED + "Usage: /paper entity list [filter] [worldName]");
                    return;
                }
                if (args.length > 3) {
                    worldName = args[3];
                } else if (sender instanceof Player) {
                    worldName = ((Player)sender).getWorld().getName();
                } else {
                    sender.sendMessage(ChatColor.RED + "Please specify the name of a world");
                    sender.sendMessage(ChatColor.RED + "To do so without a filter, specify '*' as the filter");
                    sender.sendMessage(ChatColor.RED + "Usage: /paper entity list [filter] [worldName]");
                    return;
                }
                HashMap list = Maps.newHashMap();
                World bukkitWorld = Bukkit.getWorld(worldName);
                if (bukkitWorld == null) {
                    sender.sendMessage(ChatColor.RED + "Could not load world for " + worldName + ". Please select a valid world.");
                    sender.sendMessage(ChatColor.RED + "Usage: /paper entity list [filter] [worldName]");
                    return;
                }
                ServerWorld world = ((CraftWorld)Bukkit.getWorld(worldName)).getHandle();
                HashMap nonEntityTicking = Maps.newHashMap();
                ServerChunkProvider chunkProviderServer = world.func_72863_F();
                ObjectCollection entities = world.field_217498_x.values();
                entities.forEach(e -> {
                    ResourceLocation key = new ResourceLocation("");
                    MutablePair info = list.computeIfAbsent(key, k -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                    ChunkPos chunk = new ChunkPos(e.field_70176_ah, e.field_70164_aj);
                    MutablePair mutablePair = info;
                    Integer n = (Integer)mutablePair.left;
                    mutablePair.left = (Integer)mutablePair.left + 1;
                    Integer n2 = mutablePair.left;
                    ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
                    if (!chunkProviderServer.isInEntityTickingChunk(e)) {
                        nonEntityTicking.merge(key, 1, Integer::sum);
                    }
                });
                if (names.size() == 1) {
                    ResourceLocation name = (ResourceLocation)names.iterator().next();
                    Pair info = (Pair)list.get(name);
                    int nonTicking = nonEntityTicking.getOrDefault(name, 0);
                    if (info == null) {
                        sender.sendMessage(ChatColor.RED + "No entities found.");
                        return;
                    }
                    sender.sendMessage("Entity: " + name + " Total Ticking: " + ((Integer)info.getLeft() - nonTicking) + ", Total Non-Ticking: " + nonTicking);
                    ((Map)info.getRight()).entrySet().stream().sorted((a, b) -> !((Integer)a.getValue()).equals(b.getValue()) ? (Integer)b.getValue() - (Integer)a.getValue() : ((ChunkPos)a.getKey()).toString().compareTo(((ChunkPos)b.getKey()).toString())).limit(10L).forEach(e -> sender.sendMessage("  " + e.getValue() + ": " + ((ChunkPos)e.getKey()).field_77276_a + ", " + ((ChunkPos)e.getKey()).field_77275_b + (chunkProviderServer.func_222865_a((ChunkPos)e.getKey()) ? " (Ticking)" : " (Non-Ticking)")));
                    break;
                }
                List<Pair> info = list.entrySet().stream().filter(e -> names.contains(e.getKey())).map(e -> Pair.of((Object)((ResourceLocation)e.getKey()), (Object)((Integer)((MutablePair)e.getValue()).left))).sorted((a, b) -> !((Integer)a.getRight()).equals(b.getRight()) ? (Integer)b.getRight() - (Integer)a.getRight() : ((ResourceLocation)a.getKey()).toString().compareTo(((ResourceLocation)b.getKey()).toString())).collect(Collectors.toList());
                if (info == null || info.size() == 0) {
                    sender.sendMessage(ChatColor.RED + "No entities found.");
                    return;
                }
                int count = info.stream().mapToInt(Pair::getRight).sum();
                int nonTickingCount = nonEntityTicking.values().stream().mapToInt(Integer::intValue).sum();
                sender.sendMessage("Total Ticking: " + (count - nonTickingCount) + ", Total Non-Ticking: " + nonTickingCount);
                info.forEach(e -> {
                    int nonTicking = nonEntityTicking.getOrDefault(e.getKey(), 0);
                    sender.sendMessage("  " + ((Integer)e.getValue() - nonTicking) + " (" + nonTicking + ") : " + e.getKey());
                });
                sender.sendMessage("* First number is ticking entities, second number is non-ticking entities");
            }
        }
    }

    private void dumpHeap(CommandSender sender) {
        Path dir = Paths.get("./dumps", new String[0]);
        String name = "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now());
        Command.broadcastCommandMessage(sender, ChatColor.YELLOW + "Writing JVM heap data...");
        Path file = CraftServer.dumpHeap(dir, name);
        if (file != null) {
            Command.broadcastCommandMessage(sender, ChatColor.GREEN + "Heap dump saved to " + file);
        } else {
            Command.broadcastCommandMessage(sender, ChatColor.RED + "Failed to write heap dump, see sever log for details");
        }
    }

    private void doReload(CommandSender sender) {
        Command.broadcastCommandMessage(sender, ChatColor.RED + "Please note that this command is not supported and may cause issues.");
        Command.broadcastCommandMessage(sender, ChatColor.RED + "If you encounter any issues please use the /stop command to restart your server.");
        MinecraftServer console = MinecraftServer.getServer();
        PaperConfig.init((File)MinecraftServer.options.valueOf("paper-settings"));
        for (ServerWorld world : console.func_212370_w()) {
            world.paperConfig.init();
        }
        ++console.server.reloadCount;
        Command.broadcastCommandMessage(sender, ChatColor.GREEN + "Paper config reload complete.");
    }
}

