/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.config;

import com.destroystokyo.paper.PaperCommand;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class PaperConfig {
    private static File CONFIG_FILE;
    private static final String HEADER = "This is the main configuration file for Paper.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n\nIf you need help with the configuration or have any questions related to Paper,\njoin us in our Discord or IRC channel.\n\nDiscord: https://discord.gg/papermc\nIRC: #paper @ irc.esper.net ( https://webchat.esper.net/?channels=paper ) \nWebsite: https://papermc.io/ \nDocs: https://paper.readthedocs.org/ \n";
    public static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static boolean verbose;
    private static boolean fatalError;
    private static final Pattern SPACE;
    private static final Pattern NOT_NUMERIC;
    public static String noPermissionMessage;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load paper.yml, please correct your syntax errors", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        verbose = PaperConfig.getBoolean("verbose", false);
        commands = new HashMap<String, Command>();
        commands.put("paper", new PaperCommand("paper"));
        version = PaperConfig.getInt("config-version", 20);
        PaperConfig.set("config-version", 20);
        PaperConfig.readConfig(PaperConfig.class, null);
    }

    protected static void logError(String s) {
        Bukkit.getLogger().severe(s);
    }

    protected static void fatal(String s) {
        fatalError = true;
        throw new RuntimeException("Fatal paper.yml config error: " + s);
    }

    protected static void log(String s) {
        if (verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.getServer().server.getCommandMap().register(entry.getKey(), "Paper", entry.getValue());
        }
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    public static int getSeconds(String str) {
        double num;
        str = SPACE.matcher(str).replaceAll("");
        char unit = str.charAt(str.length() - 1);
        str = NOT_NUMERIC.matcher(str).replaceAll("");
        try {
            num = Double.parseDouble(str);
        }
        catch (Exception e) {
            num = 0.0;
        }
        switch (unit) {
            case 'd': {
                num *= 86400.0;
                break;
            }
            case 'h': {
                num *= 3600.0;
                break;
            }
            case 'm': {
                num *= 60.0;
                break;
            }
        }
        return (int)num;
    }

    protected static String timeSummary(int seconds) {
        Object time = "";
        if (seconds > 86400) {
            time = (String)time + TimeUnit.SECONDS.toDays(seconds) + "d";
            seconds %= 86400;
        }
        if (seconds > 3600) {
            time = (String)time + TimeUnit.SECONDS.toHours(seconds) + "h";
            seconds %= 3600;
        }
        if (seconds > 0) {
            time = (String)time + TimeUnit.SECONDS.toMinutes(seconds) + "m";
        }
        return time;
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, def);
        return config.getDouble(path, config.getDouble(path));
    }

    private static float getFloat(String path, float def) {
        return (float)PaperConfig.getDouble(path, def);
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static void noPermissionMessage() {
        noPermissionMessage = ChatColor.translateAlternateColorCodes('&', PaperConfig.getString("messages.no-permission", noPermissionMessage));
    }

    static {
        SPACE = Pattern.compile(" ");
        NOT_NUMERIC = Pattern.compile("[^-\\d.]");
        noPermissionMessage = "&cI'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    }
}

