/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.utils;

import com.mohistmc.bukkit.nms.model.ClassMapping;
import com.mohistmc.bukkit.nms.remappers.ClassRemapperSupplier;
import com.mohistmc.bukkit.nms.remappers.MohistInheritanceMap;
import com.mohistmc.bukkit.nms.remappers.MohistInheritanceProvider;
import com.mohistmc.bukkit.nms.remappers.MohistJarMapping;
import com.mohistmc.bukkit.nms.remappers.MohistJarRemapper;
import com.mohistmc.bukkit.nms.remappers.MohistSuperClassRemapper;
import com.mohistmc.bukkit.nms.remappers.ReflectMethodRemapper;
import com.mohistmc.bukkit.nms.remappers.ReflectRemapper;
import com.mohistmc.bukkit.nms.utils.ASMUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;

public class RemapUtils {
    public static MohistJarMapping jarMapping;
    public static MohistJarRemapper jarRemapper;
    private static final List<Remapper> remappers;
    public static Map<String, String> relocations;

    public static void init() {
        jarMapping = new MohistJarMapping();
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/it/unimi/dsi/fastutil/", "it/unimi/dsi/fastutil/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/jline/", "jline/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/org/apache/commons/", "org/apache/commons/");
        RemapUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/org/objectweb/asm/", "org/objectweb/asm/");
        jarMapping.setInheritanceMap(new MohistInheritanceMap());
        jarMapping.setFallbackInheritanceProvider(new MohistInheritanceProvider());
        relocations.put("net.minecraft.server", "net.minecraft.server.v1_16_R3");
        try {
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(RemapUtils.class.getClassLoader().getResourceAsStream("mappings/spigot2srg.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jarRemapper = new MohistJarRemapper(jarMapping);
        remappers.add((Remapper)jarRemapper);
        remappers.add(new ReflectRemapper());
        jarMapping.initFastMethodMapping((Remapper)jarRemapper);
        ReflectMethodRemapper.init();
        try {
            Class.forName("com.mohistmc.bukkit.nms.proxy.ProxyMethodHandles_Lookup");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static byte[] remapFindClass(byte[] bs) {
        ClassReader reader = new ClassReader(bs);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 8);
        for (Remapper remapper : remappers) {
            ClassNode container = new ClassNode();
            ClassRemapper classRemapper = remapper instanceof ClassRemapperSupplier ? ((ClassRemapperSupplier)remapper).getClassRemapper((ClassVisitor)container) : new ClassRemapper((ClassVisitor)container, remapper);
            classNode.accept((ClassVisitor)classRemapper);
            classNode = container;
        }
        MohistSuperClassRemapper.init(classNode);
        ClassWriter writer = new ClassWriter(0);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static String map(String typeName) {
        typeName = RemapUtils.mapPackage(typeName);
        return RemapUtils.jarMapping.classes.getOrDefault(typeName, typeName);
    }

    public static String reverseMap(String typeName) {
        ClassMapping mapping = RemapUtils.jarMapping.byNMSInternalName.get(typeName);
        return mapping == null ? typeName : mapping.getNmsSrcName();
    }

    public static String reverseMap(Class<?> clazz) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? ASMUtils.toInternalName(clazz) : mapping.getNmsSrcName();
    }

    public static String mapPackage(String typeName) {
        for (Map.Entry<String, String> entry : RemapUtils.jarMapping.packages.entrySet()) {
            String prefix = entry.getKey();
            if (!typeName.startsWith(prefix)) continue;
            return entry.getValue() + typeName.substring(prefix.length());
        }
        return typeName;
    }

    public static String remapMethodDesc(String methodDescriptor) {
        Type rt = Type.getReturnType((String)methodDescriptor);
        Type[] ts = Type.getArgumentTypes((String)methodDescriptor);
        rt = Type.getType((String)ASMUtils.toDescriptorV2(RemapUtils.map(ASMUtils.getInternalName(rt))));
        for (int i = 0; i < ts.length; ++i) {
            ts[i] = Type.getType((String)ASMUtils.toDescriptorV2(RemapUtils.map(ASMUtils.getInternalName(ts[i]))));
        }
        return Type.getMethodType((Type)rt, (Type[])ts).getDescriptor();
    }

    public static String mapMethodName(Class<?> clazz, String name, MethodType methodType) {
        return RemapUtils.mapMethodName(clazz, name, methodType.parameterArray());
    }

    public static String mapMethodName(Class<?> type, String name, Class<?> ... parameterTypes) {
        return jarMapping.fastMapMethodName(type, name, parameterTypes);
    }

    public static String inverseMapMethodName(Class<?> type, String name, Class<?> ... parameterTypes) {
        return jarMapping.fastReverseMapMethodName(type, name, parameterTypes);
    }

    public static String mapFieldName(Class<?> type, String fieldName) {
        Class<?> superClass;
        String key = RemapUtils.reverseMap(type) + "/" + fieldName;
        String mapped = RemapUtils.jarMapping.fields.get(key);
        if (mapped == null && (superClass = type.getSuperclass()) != null) {
            mapped = RemapUtils.mapFieldName(superClass, fieldName);
        }
        return mapped != null ? mapped : fieldName;
    }

    public static String inverseMapFieldName(Class<?> type, String fieldName) {
        return jarMapping.fastReverseMapFieldName(type, fieldName);
    }

    public static String inverseMapName(Class<?> clazz) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? clazz.getName() : mapping.getNmsName();
    }

    public static String inverseMapSimpleName(Class<?> clazz) {
        ClassMapping mapping = RemapUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? clazz.getSimpleName() : mapping.getNmsSimpleName();
    }

    public static boolean isNMSClass(String className) {
        return className.startsWith("net.minecraft.server.") || className.startsWith("com.mohistmc.");
    }

    static {
        remappers = new ArrayList<Remapper>();
        relocations = new HashMap<String, String>();
    }
}

