/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import sun.misc.Unsafe;

public class MohistJDK9EnumHelper {
    private static MethodHandles.Lookup implLookup = null;
    private static boolean isSetup = false;

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            implLookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
        }
        catch (Exception exception) {
            // empty catch block
        }
        isSetup = true;
    }

    private static MethodHandle getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return implLookup.findConstructor(enumClass, MethodType.methodType(Void.TYPE, parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Throwable {
        int additionalParamsCount = additionalValues == null ? 0 : additionalValues.length;
        Object[] params = new Object[additionalParamsCount + 2];
        params[0] = value;
        params[1] = ordinal;
        if (additionalValues != null) {
            System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        }
        return (T)((Enum)enumClass.cast(MohistJDK9EnumHelper.getConstructorAccessor(enumClass, additionalTypes).invokeWithArguments(params)));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Throwable {
        if (target != null) {
            implLookup.findSetter(field.getDeclaringClass(), field.getName(), field.getType()).invoke(target, value);
        } else {
            implLookup.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType()).invoke(value);
        }
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Throwable {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            MohistJDK9EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Throwable {
        MohistJDK9EnumHelper.blankField(enumClass, "enumConstantDirectory");
        MohistJDK9EnumHelper.blankField(enumClass, "enumConstants");
        MohistJDK9EnumHelper.blankField(enumClass, "enumVars");
    }

    public static <T extends Enum<?>> T addEnum0(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return MohistJDK9EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            MohistJDK9EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = 4121;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            T newValue = MohistJDK9EnumHelper.makeEnum(enumType, enumName, previousValues.length, paramTypes, paramValues);
            Object base = io.izzel.arclight.api.Unsafe.staticFieldBase(valuesField);
            long offset = io.izzel.arclight.api.Unsafe.staticFieldOffset(valuesField);
            Enum[] arr = (Enum[])io.izzel.arclight.api.Unsafe.getObject(base, offset);
            Enum[] newArr = (Enum[])Array.newInstance(enumType, arr.length + 1);
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            newArr[arr.length] = newValue;
            io.izzel.arclight.api.Unsafe.putObject(base, offset, newArr);
            MohistJDK9EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        if (!isSetup) {
            MohistJDK9EnumHelper.setup();
        }
    }
}

