/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicBucketModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SeparatePerspectiveModel;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.fml.ModLoader;

public class ModelLoaderRegistry {
    public static final String WHITE_TEXTURE = "forge:white";
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final Map<ResourceLocation, IModelLoader<?>> loaders = Maps.newHashMap();
    private static volatile boolean registryFrozen = false;
    private static final Pattern FILESYSTEM_PATH_TO_RESLOC = Pattern.compile("(?:.*[\\\\/]assets[\\\\/](?<namespace>[a-z_-]+)[\\\\/]textures[\\\\/])?(?<path>[a-z_\\\\/-]+)\\.png");

    public static void init() {
        ModelLoaderRegistry.registerLoader(new ResourceLocation("minecraft", "elements"), VanillaProxy.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "obj"), OBJLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "bucket"), DynamicBucketModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "composite"), CompositeModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "multi-layer"), MultiLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "item-layers"), ItemLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "separate-perspective"), SeparatePerspectiveModel.Loader.INSTANCE);
    }

    public static void onModelLoadingStart() {
        if (!registryFrozen) {
            ModLoader.get().postEvent(new ModelRegistryEvent());
            registryFrozen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoader(ResourceLocation id, IModelLoader<?> loader) {
        if (registryFrozen) {
            throw new IllegalStateException("Can not register model loaders after models have started loading. Please use ModelRegistryEvent to register your loaders.");
        }
        Map<ResourceLocation, IModelLoader<?>> map = loaders;
        synchronized (map) {
            loaders.put(id, loader);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a(loader);
        }
    }

    public static IModelGeometry<?> getModel(ResourceLocation loaderId, JsonDeserializationContext deserializationContext, JsonObject data) {
        try {
            if (!loaders.containsKey(loaderId)) {
                throw new IllegalStateException(String.format("Model loader '%s' not found. Registered loaders: %s", loaderId, loaders.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))));
            }
            IModelLoader<?> loader = loaders.get(loaderId);
            return loader.read(deserializationContext, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Nullable
    public static IModelGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) {
        if (!object.has("loader")) {
            return null;
        }
        ResourceLocation loader = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"loader"));
        return ModelLoaderRegistry.getModel(loader, deserializationContext, object);
    }

    public static RenderMaterial resolveTexture(@Nullable String tex, IModelConfiguration owner) {
        if (tex == null) {
            return ModelLoaderRegistry.blockMaterial(WHITE_TEXTURE);
        }
        if (tex.startsWith("#")) {
            return owner.resolveTexture(tex);
        }
        Matcher match = FILESYSTEM_PATH_TO_RESLOC.matcher(tex);
        if (match.matches()) {
            String namespace = match.group("namespace");
            String path = match.group("path").replace("\\", "/");
            if (namespace != null) {
                return ModelLoaderRegistry.blockMaterial(new ResourceLocation(namespace, path));
            }
            return ModelLoaderRegistry.blockMaterial(path);
        }
        return ModelLoaderRegistry.blockMaterial(tex);
    }

    public static RenderMaterial blockMaterial(String location) {
        return new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation(location));
    }

    public static RenderMaterial blockMaterial(ResourceLocation location) {
        return new RenderMaterial(AtlasTexture.field_110575_b, location);
    }

    @Nullable
    public static IModelTransform deserializeModelTransforms(JsonDeserializationContext deserializationContext, JsonObject modelData) {
        if (!modelData.has("transform")) {
            return null;
        }
        return ModelLoaderRegistry.deserializeTransform(deserializationContext, modelData.get("transform")).orElse(null);
    }

    public static Optional<IModelTransform> deserializeTransform(JsonDeserializationContext context, JsonElement transformData) {
        if (!transformData.isJsonObject()) {
            try {
                TransformationMatrix base = (TransformationMatrix)context.deserialize(transformData, TransformationMatrix.class);
                return Optional.of(new SimpleModelTransform(ImmutableMap.of(), base.blockCenterToCorner()));
            }
            catch (JsonParseException e) {
                throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformData);
            }
        }
        JsonObject transform = transformData.getAsJsonObject();
        EnumMap transforms = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson", ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson_righthand", ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson_lefthand", ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson", ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson_righthand", ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson_lefthand", ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "head", ItemCameraTransforms.TransformType.HEAD);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "gui", ItemCameraTransforms.TransformType.GUI);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "ground", ItemCameraTransforms.TransformType.GROUND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "fixed", ItemCameraTransforms.TransformType.FIXED);
        int k = transform.entrySet().size();
        if (transform.has("matrix")) {
            --k;
        }
        if (transform.has("translation")) {
            --k;
        }
        if (transform.has("rotation")) {
            --k;
        }
        if (transform.has("scale")) {
            --k;
        }
        if (transform.has("post-rotation")) {
            --k;
        }
        if (transform.has("origin")) {
            --k;
        }
        if (k > 0) {
            throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
        }
        TransformationMatrix base = TransformationMatrix.func_227983_a_();
        if (!transform.entrySet().isEmpty()) {
            base = (TransformationMatrix)context.deserialize((JsonElement)transform, TransformationMatrix.class);
        }
        SimpleModelTransform state = new SimpleModelTransform(Maps.immutableEnumMap((Map)transforms), base);
        return Optional.of(state);
    }

    private static void deserializeTRSR(JsonDeserializationContext context, EnumMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, JsonObject transform, String name, ItemCameraTransforms.TransformType itemCameraTransform) {
        if (transform.has(name)) {
            TransformationMatrix t = (TransformationMatrix)context.deserialize(transform.remove(name), TransformationMatrix.class);
            transforms.put(itemCameraTransform, t.blockCenterToCorner());
        }
    }

    public static IBakedModel bakeHelper(BlockModel blockModel, ModelBakery modelBakery, BlockModel otherModel, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation, boolean guiLight3d) {
        IModelGeometry<?> customModel = blockModel.customData.getCustomGeometry();
        IModelTransform customModelState = blockModel.customData.getCustomModelState();
        if (customModelState != null) {
            modelTransform = new ModelTransformComposition(modelTransform, customModelState, modelTransform.func_188049_c());
        }
        IBakedModel model = customModel != null ? customModel.bake(blockModel.customData, modelBakery, spriteGetter, modelTransform, blockModel.getOverrides(modelBakery, otherModel, spriteGetter), modelLocation) : (blockModel.func_178310_f() == ModelBakery.field_177606_o ? ITEM_MODEL_GENERATOR.func_209579_a(spriteGetter, blockModel).func_228813_a_(modelBakery, blockModel, spriteGetter, modelTransform, modelLocation, guiLight3d) : blockModel.bakeVanilla(modelBakery, otherModel, spriteGetter, modelTransform, modelLocation, guiLight3d));
        if (customModelState != null && !model.doesHandlePerspectives()) {
            model = new PerspectiveMapWrapper(model, customModelState);
        }
        return model;
    }

    public static class ExpandedBlockModelDeserializer
    extends BlockModel.Deserializer {
        public static final Gson INSTANCE = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new ExpandedBlockModelDeserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).registerTypeAdapter(TransformationMatrix.class, (Object)new TransformationHelper.Deserializer()).create();

        public BlockModel deserialize(JsonElement element, Type targetType, JsonDeserializationContext deserializationContext) throws JsonParseException {
            IModelTransform modelState;
            BlockModel model = super.deserialize(element, targetType, deserializationContext);
            JsonObject jsonobject = element.getAsJsonObject();
            IModelGeometry<?> geometry = ModelLoaderRegistry.deserializeGeometry(deserializationContext, jsonobject);
            List elements = model.func_178298_a();
            if (geometry != null) {
                elements.clear();
                model.customData.setCustomGeometry(geometry);
            }
            if ((modelState = ModelLoaderRegistry.deserializeModelTransforms(deserializationContext, jsonobject)) != null) {
                model.customData.setCustomModelState(modelState);
            }
            if (jsonobject.has("visibility")) {
                JsonObject visibility = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"visibility");
                for (Map.Entry part : visibility.entrySet()) {
                    model.customData.visibilityData.setVisibilityState((String)part.getKey(), ((JsonElement)part.getValue()).getAsBoolean());
                }
            }
            return model;
        }
    }

    public static class VanillaProxy
    implements ISimpleModelGeometry<VanillaProxy> {
        private final List<BlockPart> elements;

        public VanillaProxy(List<BlockPart> list) {
            this.elements = list;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
            for (BlockPart blockpart : this.elements) {
                for (Direction direction : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(direction);
                    TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(owner.resolveTexture(blockpartface.field_178242_d));
                    if (blockpartface.field_178244_b == null) {
                        modelBuilder.addGeneralQuad(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation));
                        continue;
                    }
                    modelBuilder.addFaceQuad(modelTransform.func_225615_b_().rotateTransform(blockpartface.field_178244_b), BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation));
                }
            }
        }

        @Override
        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (BlockPart part : this.elements) {
                for (BlockPartFace face : part.field_178240_c.values()) {
                    RenderMaterial texture = owner.resolveTexture(face.field_178242_d);
                    if (Objects.equals(texture, MissingTextureSprite.func_195675_b().toString())) {
                        missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                    }
                    textures.add(texture);
                }
            }
            return textures;
        }

        public static class Loader
        implements IModelLoader<VanillaProxy> {
            public static final Loader INSTANCE = new Loader();

            private Loader() {
            }

            @Override
            public void func_195410_a(IResourceManager resourceManager) {
            }

            @Override
            public VanillaProxy read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
                List<BlockPart> list = this.getModelElements(deserializationContext, modelContents);
                return new VanillaProxy(list);
            }

            private List<BlockPart> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
                ArrayList list = Lists.newArrayList();
                if (object.has("elements")) {
                    for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)object, (String)"elements")) {
                        list.add((BlockPart)deserializationContext.deserialize(jsonelement, BlockPart.class));
                    }
                }
                return list;
            }
        }
    }
}

