/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IBeaconBeamColorProvider;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;

public interface IForgeBlock {
    default public Block getBlock() {
        return (Block)this;
    }

    default public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getBlock().func_208618_m();
    }

    default public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_185906_d();
    }

    default public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return state.func_177230_c().func_203417_a((ITag)BlockTags.field_232878_as_);
    }

    default public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return this == Blocks.field_150480_ab || this == Blocks.field_150353_l;
    }

    default public boolean hasTileEntity(BlockState state) {
        return this instanceof ITileEntityProvider;
    }

    @Nullable
    default public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this.getBlock() instanceof ITileEntityProvider) {
            return ((ITileEntityProvider)this.getBlock()).func_196283_a_(world);
        }
        return null;
    }

    default public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ForgeHooks.canHarvestBlock(state, player, world, pos);
    }

    default public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        this.getBlock().func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, fluid.func_206883_i(), world.field_72995_K ? 11 : 3);
    }

    default public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, @Nullable Entity player) {
        return this.getBlock() instanceof BedBlock;
    }

    default public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return state.func_215688_a(world, pos, entityType);
    }

    default public Optional<Vector3d> getBedSpawnPosition(EntityType<?> entityType, BlockState state, IWorldReader world, BlockPos pos, float orientation, @Nullable LivingEntity sleeper) {
        if (world instanceof World) {
            return BedBlock.func_242652_a(entityType, (ICollisionReader)world, (BlockPos)pos, (float)orientation);
        }
        return Optional.empty();
    }

    default public void setBedOccupied(BlockState state, World world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    default public Direction getBedDirection(BlockState state, IWorldReader world, BlockPos pos) {
        return (Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D);
    }

    default public boolean isAir(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_185904_a() == Material.field_151579_a;
    }

    default public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return this.isAir(state, (IBlockReader)world, pos) || state.func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    default public boolean canBeReplacedByLogs(BlockState state, IWorldReader world, BlockPos pos) {
        return this.isAir(state, (IBlockReader)world, pos) || state.func_235714_a_((ITag)BlockTags.field_206952_E) || this == Blocks.field_196658_i || state.func_235714_a_(Tags.Blocks.DIRT) || this.getBlock().func_203417_a((ITag)BlockTags.field_200031_h) || this.getBlock().func_203417_a((ITag)BlockTags.field_200030_g) || this == Blocks.field_150395_bd;
    }

    default public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getBlock().func_149638_a();
    }

    default public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return state.func_185897_m() && side != null;
    }

    default public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getBlock().func_185473_a(world, pos, state);
    }

    default public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return false;
    }

    default public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    public boolean canSustainPlant(BlockState var1, IBlockReader var2, BlockPos var3, Direction var4, IPlantable var5);

    @Deprecated
    default public void onPlantGrow(BlockState state, IWorld world, BlockPos pos, BlockPos source) {
        if (state.func_235714_a_(Tags.Blocks.DIRT)) {
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    default public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        if (state.func_203425_a(Blocks.field_150458_ak)) {
            return (Integer)state.func_177229_b((Property)FarmlandBlock.field_176531_a) > 0;
        }
        return false;
    }

    default public boolean isConduitFrame(BlockState state, IWorldReader world, BlockPos pos, BlockPos conduit) {
        return state.func_177230_c() == Blocks.field_180397_cI || state.func_177230_c() == Blocks.field_196779_gQ || state.func_177230_c() == Blocks.field_180398_cJ || state.func_177230_c() == Blocks.field_196781_gR;
    }

    default public boolean isPortalFrame(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150343_Z);
    }

    default public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return 0;
    }

    default public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return state.func_185907_a(direction);
    }

    default public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150342_X) ? 1.0f : 0.0f;
    }

    default public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
    }

    @Deprecated
    default public void observedNeighborChange(BlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
    }

    default public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return state.func_215686_e((IBlockReader)world, pos);
    }

    default public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return false;
    }

    public ToolType getHarvestTool(BlockState var1);

    public int getHarvestLevel(BlockState var1);

    default public boolean isToolEffective(BlockState state, ToolType tool) {
        if (tool == ToolType.PICKAXE && (this.getBlock() == Blocks.field_150450_ax || this.getBlock() == Blocks.field_150379_bu || this.getBlock() == Blocks.field_150343_Z)) {
            return false;
        }
        return tool == this.getHarvestTool(state);
    }

    default public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getBlock().func_220072_p(state);
    }

    @Nullable
    default public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        if (this.getBlock() instanceof IBeaconBeamColorProvider) {
            return ((IBeaconBeamColorProvider)this.getBlock()).func_196457_d().func_193349_f();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Vector3d getFogColor(BlockState state, IWorldReader world, BlockPos pos, Entity entity, Vector3d originalColor, float partialTicks) {
        if (state.func_185904_a() == Material.field_151586_h) {
            float f12 = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity ent = (LivingEntity)entity;
                f12 = (float)EnchantmentHelper.func_185292_c((LivingEntity)ent) * 0.2f;
                if (ent.func_70644_a(Effects.field_76427_o)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            return new Vector3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
        }
        if (state.func_185904_a() == Material.field_151587_i) {
            return new Vector3d((double)0.6f, (double)0.1f, 0.0);
        }
        return originalColor;
    }

    default public BlockState getStateAtViewpoint(BlockState state, IBlockReader world, BlockPos pos, Vector3d viewpoint) {
        return state;
    }

    @Nullable
    default public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return state.func_177230_c() == Blocks.field_150353_l ? PathNodeType.LAVA : (state.isBurning(world, pos) ? PathNodeType.DAMAGE_FIRE : null);
    }

    default public boolean isSlimeBlock(BlockState state) {
        return state.func_177230_c() == Blocks.field_180399_cE;
    }

    default public boolean isStickyBlock(BlockState state) {
        return state.func_177230_c() == Blocks.field_180399_cE || state.func_177230_c() == Blocks.field_226907_mc_;
    }

    default public boolean canStickTo(BlockState state, BlockState other) {
        if (state.func_177230_c() == Blocks.field_226907_mc_ && other.func_177230_c() == Blocks.field_180399_cE) {
            return false;
        }
        if (state.func_177230_c() == Blocks.field_180399_cE && other.func_177230_c() == Blocks.field_226907_mc_) {
            return false;
        }
        return state.isStickyBlock() || other.isStickyBlock();
    }

    default public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.field_150480_ab).func_220274_q(state);
    }

    default public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return state.getFlammability(world, pos, face) > 0;
    }

    default public void catchFire(BlockState state, World world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    default public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.field_150480_ab).func_220275_r(state);
    }

    default public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return state.func_235714_a_(world.func_230315_m_().func_241515_q_());
    }

    default public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (entity instanceof EnderDragonEntity) {
            return !BlockTags.field_219754_W.func_230235_a_((Object)this.getBlock());
        }
        if (entity instanceof WitherEntity || entity instanceof WitherSkullEntity) {
            return state.isAir(world, pos) || WitherEntity.func_181033_a((BlockState)state);
        }
        return true;
    }

    default public boolean canDropFromExplosion(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return state.func_177230_c().func_149659_a(explosion);
    }

    public Set<ResourceLocation> getTags();

    default public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.getBlock().func_180652_a(world, pos, explosion);
    }

    default public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return this.getBlock().func_203417_a((ITag)BlockTags.field_219748_G) || this.getBlock().func_203417_a((ITag)BlockTags.field_219757_z) || this.getBlock() instanceof FenceGateBlock;
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return state.func_177230_c() instanceof BreakableBlock || state.func_177230_c() instanceof LeavesBlock;
    }

    @Nullable
    default public BlockState getToolModifiedState(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        if (toolType == ToolType.AXE) {
            return AxeItem.getAxeStrippingState((BlockState)state);
        }
        if (toolType == ToolType.HOE) {
            return HoeItem.getHoeTillingState((BlockState)state);
        }
        return toolType == ToolType.SHOVEL ? ShovelItem.getShovelPathingState((BlockState)state) : null;
    }

    default public boolean isScaffolding(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return state.func_203425_a(Blocks.field_222420_lI);
    }
}

