/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.model.animation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.model.animation.IJointClip;
import net.minecraftforge.common.model.animation.JointClips;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Clips {
    private static final Logger LOGGER = LogManager.getLogger();

    @OnlyIn(value=Dist.CLIENT)
    public static IClip getModelClipNode(ResourceLocation modelLocation, String clipName) {
        IUnbakedModel model = ModelLoader.defaultModelGetter().apply(modelLocation);
        Optional clip = model.getClip(clipName);
        if (clip.isPresent()) {
            return new ModelClip((IClip)clip.get(), modelLocation, clipName);
        }
        LOGGER.error("Unable to find clip {} in the model {}", (Object)clipName, (Object)modelLocation);
        return new ModelClip(IdentityClip.INSTANCE, modelLocation, clipName);
    }

    private static IJointClip blendClips(IJoint joint, final IJointClip fromClip, final IJointClip toClip, final ITimeValue input, final ITimeValue progress) {
        return new IJointClip(){

            @Override
            public TransformationMatrix apply(float time) {
                float clipTime = input.apply(time);
                return TransformationHelper.slerp(fromClip.apply(clipTime), toClip.apply(clipTime), MathHelper.func_76131_a((float)progress.apply(time), (float)0.0f, (float)1.0f));
            }
        };
    }

    public static Pair<IModelTransform, Iterable<Event>> apply(final IClip clip, float lastPollTime, final float time) {
        return Pair.of((Object)new IModelTransform(){

            public TransformationMatrix func_225615_b_() {
                return TransformationMatrix.func_227983_a_();
            }

            public TransformationMatrix getPartTransformation(Object part) {
                if (!(part instanceof IJoint)) {
                    return TransformationMatrix.func_227983_a_();
                }
                IJoint joint = (IJoint)part;
                TransformationMatrix jointTransform = clip.apply(joint).apply(time).func_227985_a_(joint.getInvBindPose());
                Optional<? extends IJoint> parent = joint.getParent();
                while (parent.isPresent()) {
                    TransformationMatrix parentTransform = clip.apply(parent.get()).apply(time);
                    jointTransform = parentTransform.func_227985_a_(jointTransform);
                    parent = parent.get().getParent();
                }
                return jointTransform;
            }
        }, clip.pastEvents(lastPollTime, time));
    }

    public static enum CommonClipTypeAdapterFactory implements TypeAdapterFactory
    {
        INSTANCE;

        private final ThreadLocal<Function<String, IClip>> clipResolver = new ThreadLocal();

        public void setClipResolver(@Nullable Function<String, IClip> clipResolver) {
            this.clipResolver.set(clipResolver);
        }

        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != IClip.class) {
                return null;
            }
            final TypeAdapter parameterAdapter = gson.getAdapter(ITimeValue.class);
            return new TypeAdapter<IClip>(){

                public void write(JsonWriter out, IClip clip) throws IOException {
                    if (clip instanceof IStringSerializable) {
                        out.value("#" + ((IStringSerializable)clip).func_176610_l());
                        return;
                    }
                    if (clip instanceof TimeClip) {
                        out.beginArray();
                        out.value("apply");
                        TimeClip timeClip = (TimeClip)clip;
                        this.write(out, timeClip.childClip);
                        parameterAdapter.write(out, (Object)timeClip.time);
                        out.endArray();
                        return;
                    }
                    if (clip instanceof SlerpClip) {
                        out.beginArray();
                        out.value("slerp");
                        SlerpClip slerpClip = (SlerpClip)clip;
                        this.write(out, slerpClip.from);
                        this.write(out, slerpClip.to);
                        parameterAdapter.write(out, (Object)slerpClip.input);
                        parameterAdapter.write(out, (Object)slerpClip.progress);
                        out.endArray();
                        return;
                    }
                    if (clip instanceof TriggerClip) {
                        out.beginArray();
                        out.value("trigger_positive");
                        TriggerClip triggerClip = (TriggerClip)clip;
                        this.write(out, triggerClip.clip);
                        parameterAdapter.write(out, (Object)triggerClip.parameter);
                        out.value(triggerClip.event);
                        out.endArray();
                        return;
                    }
                    if (clip instanceof ModelClip) {
                        ModelClip modelClip = (ModelClip)clip;
                        out.value(modelClip.modelLocation + "@" + modelClip.clipName);
                        return;
                    }
                    throw new NotImplementedException("unknown Clip to json: " + clip);
                }

                public IClip read(JsonReader in) throws IOException {
                    switch (in.peek()) {
                        case BEGIN_ARRAY: {
                            IClip clip;
                            in.beginArray();
                            String type = in.nextString();
                            if ("apply".equals(type)) {
                                clip = new TimeClip(this.read(in), (ITimeValue)parameterAdapter.read(in));
                            } else if ("slerp".equals(type)) {
                                clip = new SlerpClip(this.read(in), this.read(in), (ITimeValue)parameterAdapter.read(in), (ITimeValue)parameterAdapter.read(in));
                            } else if ("trigger_positive".equals(type)) {
                                clip = new TriggerClip(this.read(in), (ITimeValue)parameterAdapter.read(in), in.nextString());
                            } else {
                                throw new IOException("Unknown Clip type \"" + type + "\"");
                            }
                            in.endArray();
                            return clip;
                        }
                        case STRING: {
                            String string = in.nextString();
                            if (string.equals("#identity")) {
                                return IdentityClip.INSTANCE;
                            }
                            if (string.startsWith("#")) {
                                return new ClipReference(string.substring(1), clipResolver.get());
                            }
                            int at = string.lastIndexOf(64);
                            String location = string.substring(0, at);
                            String clipName = string.substring(at + 1, string.length());
                            Object model = location.indexOf(35) != -1 ? new ModelResourceLocation(location) : new ResourceLocation(location);
                            return Clips.getModelClipNode((ResourceLocation)model, clipName);
                        }
                    }
                    throw new IOException("expected Clip, got " + in.peek());
                }
            };
        }
    }

    public static final class ClipReference
    implements IClip,
    IStringSerializable {
        private final String clipName;
        private final Function<String, IClip> clipResolver;
        private IClip clip;

        public ClipReference(String clipName, Function<String, IClip> clipResolver) {
            this.clipName = clipName;
            this.clipResolver = clipResolver;
        }

        private void resolve() {
            if (this.clip == null) {
                if (this.clipResolver != null) {
                    this.clip = this.clipResolver.apply(this.clipName);
                }
                if (this.clip == null) {
                    throw new IllegalArgumentException("Couldn't resolve clip " + this.clipName);
                }
            }
        }

        @Override
        public IJointClip apply(IJoint joint) {
            this.resolve();
            return this.clip.apply(joint);
        }

        @Override
        public Iterable<Event> pastEvents(float lastPollTime, float time) {
            this.resolve();
            return this.clip.pastEvents(lastPollTime, time);
        }

        public String func_176610_l() {
            return this.clipName;
        }

        public int hashCode() {
            this.resolve();
            return this.clip.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClipReference other = (ClipReference)obj;
            this.resolve();
            other.resolve();
            return Objects.equal((Object)this.clip, (Object)other.clip);
        }
    }

    public static final class TriggerClip
    implements IClip {
        private final IClip clip;
        private final ITimeValue parameter;
        private final String event;

        public TriggerClip(IClip clip, ITimeValue parameter, String event) {
            this.clip = clip;
            this.parameter = parameter;
            this.event = event;
        }

        @Override
        public IJointClip apply(IJoint joint) {
            return this.clip.apply(joint);
        }

        @Override
        public Iterable<Event> pastEvents(float lastPollTime, float time) {
            if (this.parameter.apply(lastPollTime) < 0.0f && this.parameter.apply(time) >= 0.0f) {
                return Iterables.mergeSorted((Iterable)ImmutableSet.of(this.clip.pastEvents(lastPollTime, time), (Object)ImmutableSet.of((Object)new Event(this.event, 0.0f))), (Comparator)Ordering.natural());
            }
            return this.clip.pastEvents(lastPollTime, time);
        }
    }

    public static final class SlerpClip
    implements IClip {
        private final IClip from;
        private final IClip to;
        private final ITimeValue input;
        private final ITimeValue progress;

        public SlerpClip(IClip from, IClip to, ITimeValue input, ITimeValue progress) {
            this.from = from;
            this.to = to;
            this.input = input;
            this.progress = progress;
        }

        @Override
        public IJointClip apply(IJoint joint) {
            IJointClip fromClip = this.from.apply(joint);
            IJointClip toClip = this.to.apply(joint);
            return Clips.blendClips(joint, fromClip, toClip, this.input, this.progress);
        }

        @Override
        public Iterable<Event> pastEvents(float lastPollTime, float time) {
            float clipLastPollTime = this.input.apply(lastPollTime);
            float clipTime = this.input.apply(time);
            return Iterables.mergeSorted((Iterable)ImmutableSet.of(this.from.pastEvents(clipLastPollTime, clipTime), this.to.pastEvents(clipLastPollTime, clipTime)), (Comparator)Ordering.natural());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.from, this.to, this.input, this.progress});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SlerpClip other = (SlerpClip)obj;
            return Objects.equal((Object)this.from, (Object)other.from) && Objects.equal((Object)this.to, (Object)other.to) && Objects.equal((Object)this.input, (Object)other.input) && Objects.equal((Object)this.progress, (Object)other.progress);
        }
    }

    public static final class TimeClip
    implements IClip {
        private final IClip childClip;
        private final ITimeValue time;

        public TimeClip(IClip childClip, ITimeValue time) {
            this.childClip = childClip;
            this.time = time;
        }

        @Override
        public IJointClip apply(final IJoint joint) {
            return new IJointClip(){
                private final IJointClip parent;
                {
                    this.parent = childClip.apply(joint);
                }

                @Override
                public TransformationMatrix apply(float time) {
                    return this.parent.apply(time.apply(time));
                }
            };
        }

        @Override
        public Iterable<Event> pastEvents(float lastPollTime, float time) {
            return this.childClip.pastEvents(this.time.apply(lastPollTime), this.time.apply(time));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.childClip, this.time});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeClip other = (TimeClip)obj;
            return Objects.equal((Object)this.childClip, (Object)other.childClip) && Objects.equal((Object)this.time, (Object)other.time);
        }
    }

    public static final class ModelClip
    implements IClip {
        private final IClip childClip;
        private final ResourceLocation modelLocation;
        private final String clipName;

        public ModelClip(IClip childClip, ResourceLocation modelLocation, String clipName) {
            this.childClip = childClip;
            this.modelLocation = modelLocation;
            this.clipName = clipName;
        }

        @Override
        public IJointClip apply(IJoint joint) {
            return this.childClip.apply(joint);
        }

        @Override
        public Iterable<Event> pastEvents(float lastPollTime, float time) {
            return this.childClip.pastEvents(lastPollTime, time);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.modelLocation, this.clipName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModelClip other = (ModelClip)obj;
            return Objects.equal((Object)this.modelLocation, (Object)other.modelLocation) && Objects.equal((Object)this.clipName, (Object)other.clipName);
        }
    }

    public static enum IdentityClip implements IClip,
    IStringSerializable
    {
        INSTANCE;


        @Override
        public IJointClip apply(IJoint joint) {
            return JointClips.IdentityJointClip.INSTANCE;
        }

        @Override
        public Iterable<Event> pastEvents(float lastPollTime, float time) {
            return ImmutableSet.of();
        }

        public String func_176610_l() {
            return "identity";
        }
    }
}

