/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class ForgeChunkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TicketType<TicketOwner<BlockPos>> BLOCK = TicketType.func_219484_a((String)"forge:block", Comparator.comparing(info -> info));
    private static final TicketType<TicketOwner<BlockPos>> BLOCK_TICKING = TicketType.func_219484_a((String)"forge:block_ticking", Comparator.comparing(info -> info));
    private static final TicketType<TicketOwner<UUID>> ENTITY = TicketType.func_219484_a((String)"forge:entity", Comparator.comparing(info -> info));
    private static final TicketType<TicketOwner<UUID>> ENTITY_TICKING = TicketType.func_219484_a((String)"forge:entity_ticking", Comparator.comparing(info -> info));
    private static final Map<String, LoadingValidationCallback> callbacks = new HashMap<String, LoadingValidationCallback>();

    public static void setForcedChunkLoadingCallback(String modId, LoadingValidationCallback callback) {
        if (ModList.get().isLoaded(modId)) {
            callbacks.put(modId, callback);
        } else {
            LOGGER.warn("A mod attempted to set the forced chunk validation loading callback for an unloaded mod of id: {}", (Object)modId);
        }
    }

    public static boolean hasForcedChunks(ServerWorld world) {
        ForcedChunksSaveData data = (ForcedChunksSaveData)world.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        if (data == null) {
            return false;
        }
        return !data.func_212438_a().isEmpty() || !data.getBlockForcedChunks().isEmpty() || !data.getEntityForcedChunks().isEmpty();
    }

    public static boolean forceChunk(ServerWorld world, String modId, BlockPos owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return ForgeChunkManager.forceChunk(world, modId, owner, chunkX, chunkZ, add, ticking, ticking ? BLOCK_TICKING : BLOCK, ForcedChunksSaveData::getBlockForcedChunks);
    }

    public static boolean forceChunk(ServerWorld world, String modId, Entity owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return ForgeChunkManager.forceChunk(world, modId, owner.func_110124_au(), chunkX, chunkZ, add, ticking);
    }

    public static boolean forceChunk(ServerWorld world, String modId, UUID owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return ForgeChunkManager.forceChunk(world, modId, owner, chunkX, chunkZ, add, ticking, ticking ? ENTITY_TICKING : ENTITY, ForcedChunksSaveData::getEntityForcedChunks);
    }

    private static <T extends Comparable<? super T>> boolean forceChunk(ServerWorld world, String modId, T owner, int chunkX, int chunkZ, boolean add, boolean ticking, TicketType<TicketOwner<T>> type, Function<ForcedChunksSaveData, TicketTracker<T>> ticketGetter) {
        boolean success;
        if (!ModList.get().isLoaded(modId)) {
            LOGGER.warn("A mod attempted to force a chunk for an unloaded mod of id: {}", (Object)modId);
            return false;
        }
        ForcedChunksSaveData saveData = (ForcedChunksSaveData)world.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        long chunk = pos.func_201841_a();
        TicketTracker<T> tickets = ticketGetter.apply(saveData);
        TicketOwner<T> ticketOwner = new TicketOwner<T>(modId, owner);
        if (add) {
            success = tickets.add(ticketOwner, chunk, ticking);
            if (success) {
                world.func_212866_a_(chunkX, chunkZ);
            }
        } else {
            success = tickets.remove(ticketOwner, chunk, ticking);
        }
        if (success) {
            saveData.func_76186_a(true);
            ForgeChunkManager.forceChunk(world, pos, type, ticketOwner, add, ticking);
        }
        return success;
    }

    private static <T extends Comparable<? super T>> void forceChunk(ServerWorld world, ChunkPos pos, TicketType<TicketOwner<T>> type, TicketOwner<T> owner, boolean add, boolean ticking) {
        if (add) {
            if (ticking) {
                world.func_72863_F().registerTickingTicket(type, pos, 2, owner);
            } else {
                world.func_72863_F().func_217228_a(type, pos, 2, owner);
            }
        } else if (ticking) {
            world.func_72863_F().releaseTickingTicket(type, pos, 2, owner);
        } else {
            world.func_72863_F().func_217222_b(type, pos, 2, owner);
        }
    }

    public static void reinstatePersistentChunks(ServerWorld world, ForcedChunksSaveData saveData) {
        if (!callbacks.isEmpty()) {
            Map blockTickets = ForgeChunkManager.gatherTicketsByModId(saveData.getBlockForcedChunks());
            Map entityTickets = ForgeChunkManager.gatherTicketsByModId(saveData.getEntityForcedChunks());
            for (Map.Entry<String, LoadingValidationCallback> entry : callbacks.entrySet()) {
                String modId = entry.getKey();
                boolean hasBlockTicket = blockTickets.containsKey(modId);
                boolean hasEntityTicket = entityTickets.containsKey(modId);
                if (!hasBlockTicket && !hasEntityTicket) continue;
                Map<BlockPos, Pair<LongSet, LongSet>> ownedBlockTickets = hasBlockTicket ? Collections.unmodifiableMap(blockTickets.get(modId)) : Collections.emptyMap();
                Map<UUID, Pair<LongSet, LongSet>> ownedEntityTickets = hasEntityTicket ? Collections.unmodifiableMap(entityTickets.get(modId)) : Collections.emptyMap();
                entry.getValue().validateTickets(world, new TicketHelper(saveData, modId, ownedBlockTickets, ownedEntityTickets));
            }
        }
        ForgeChunkManager.reinstatePersistentChunks(world, BLOCK, saveData.getBlockForcedChunks().chunks, false);
        ForgeChunkManager.reinstatePersistentChunks(world, BLOCK_TICKING, saveData.getBlockForcedChunks().tickingChunks, true);
        ForgeChunkManager.reinstatePersistentChunks(world, ENTITY, saveData.getEntityForcedChunks().chunks, false);
        ForgeChunkManager.reinstatePersistentChunks(world, ENTITY_TICKING, saveData.getEntityForcedChunks().tickingChunks, true);
    }

    private static <T extends Comparable<? super T>> Map<String, Map<T, Pair<LongSet, LongSet>>> gatherTicketsByModId(TicketTracker<T> tickets) {
        HashMap<String, Map<T, Pair<LongSet, LongSet>>> modSortedOwnedChunks = new HashMap<String, Map<T, Pair<LongSet, LongSet>>>();
        ForgeChunkManager.gatherTicketsByModId(tickets.chunks, Pair::getFirst, modSortedOwnedChunks);
        ForgeChunkManager.gatherTicketsByModId(tickets.tickingChunks, Pair::getSecond, modSortedOwnedChunks);
        return modSortedOwnedChunks;
    }

    private static <T extends Comparable<? super T>> void gatherTicketsByModId(Map<TicketOwner<T>, LongSet> tickets, Function<Pair<LongSet, LongSet>, LongSet> typeGetter, Map<String, Map<T, Pair<LongSet, LongSet>>> modSortedOwnedChunks) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : tickets.entrySet()) {
            Pair pair = modSortedOwnedChunks.computeIfAbsent(entry.getKey().modId, modId -> new HashMap()).computeIfAbsent(entry.getKey().owner, owner -> new Pair((Object)new LongOpenHashSet(), (Object)new LongOpenHashSet()));
            typeGetter.apply((Pair<LongSet, LongSet>)pair).addAll((LongCollection)entry.getValue());
        }
    }

    private static <T extends Comparable<? super T>> void reinstatePersistentChunks(ServerWorld world, TicketType<TicketOwner<T>> type, Map<TicketOwner<T>, LongSet> tickets, boolean ticking) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : tickets.entrySet()) {
            LongIterator longIterator = entry.getValue().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                ForgeChunkManager.forceChunk(world, new ChunkPos(chunk), type, entry.getKey(), true, ticking);
            }
        }
    }

    public static void writeForgeForcedChunks(CompoundNBT nbt, TicketTracker<BlockPos> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        if (!blockForcedChunks.isEmpty() || !entityForcedChunks.isEmpty()) {
            HashMap<String, Long2ObjectMap<CompoundNBT>> forcedEntries = new HashMap<String, Long2ObjectMap<CompoundNBT>>();
            ForgeChunkManager.writeForcedChunkOwners(forcedEntries, blockForcedChunks, "Blocks", 10, (T pos, ListNBT forcedBlocks) -> forcedBlocks.add((Object)NBTUtil.func_186859_a((BlockPos)pos)));
            ForgeChunkManager.writeForcedChunkOwners(forcedEntries, entityForcedChunks, "Entities", 11, (T uuid, ListNBT forcedEntities) -> forcedEntities.add((Object)NBTUtil.func_240626_a_((UUID)uuid)));
            ListNBT forcedChunks = new ListNBT();
            for (Map.Entry entry : forcedEntries.entrySet()) {
                CompoundNBT forcedEntry = new CompoundNBT();
                forcedEntry.func_74778_a("Mod", (String)entry.getKey());
                ListNBT modForced = new ListNBT();
                modForced.addAll((Collection)((Long2ObjectMap)entry.getValue()).values());
                forcedEntry.func_218657_a("ModForced", (INBT)modForced);
                forcedChunks.add((Object)forcedEntry);
            }
            nbt.func_218657_a("ForgeForced", (INBT)forcedChunks);
        }
    }

    private static <T extends Comparable<? super T>> void writeForcedChunkOwners(Map<String, Long2ObjectMap<CompoundNBT>> forcedEntries, TicketTracker<T> tracker, String listKey, int listType, BiConsumer<T, ListNBT> ownerWriter) {
        ForgeChunkManager.writeForcedChunkOwners(forcedEntries, tracker.chunks, listKey, listType, ownerWriter);
        ForgeChunkManager.writeForcedChunkOwners(forcedEntries, tracker.tickingChunks, "Ticking" + listKey, listType, ownerWriter);
    }

    private static <T extends Comparable<? super T>> void writeForcedChunkOwners(Map<String, Long2ObjectMap<CompoundNBT>> forcedEntries, Map<TicketOwner<T>, LongSet> forcedChunks, String listKey, int listType, BiConsumer<T, ListNBT> ownerWriter) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : forcedChunks.entrySet()) {
            Long2ObjectMap modForced = forcedEntries.computeIfAbsent(entry.getKey().modId, modId -> new Long2ObjectOpenHashMap());
            LongIterator longIterator = entry.getValue().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                CompoundNBT modEntry = (CompoundNBT)modForced.computeIfAbsent(chunk, chunkPos -> {
                    CompoundNBT baseEntry = new CompoundNBT();
                    baseEntry.func_74772_a("Chunk", chunkPos);
                    return baseEntry;
                });
                ListNBT ownerList = modEntry.func_150295_c(listKey, listType);
                ownerWriter.accept(entry.getKey().owner, ownerList);
                modEntry.func_218657_a(listKey, (INBT)ownerList);
            }
        }
    }

    public static void readForgeForcedChunks(CompoundNBT nbt, TicketTracker<BlockPos> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        ListNBT forcedChunks = nbt.func_150295_c("ForgeForced", 10);
        for (int i = 0; i < forcedChunks.size(); ++i) {
            CompoundNBT forcedEntry = forcedChunks.func_150305_b(i);
            String modId = forcedEntry.func_74779_i("Mod");
            if (ModList.get().isLoaded(modId)) {
                ListNBT modForced = forcedEntry.func_150295_c("ModForced", 10);
                for (int j = 0; j < modForced.size(); ++j) {
                    CompoundNBT modEntry = modForced.func_150305_b(j);
                    long chunkPos = modEntry.func_74763_f("Chunk");
                    ForgeChunkManager.readBlockForcedChunks(modId, chunkPos, modEntry, "Blocks", blockForcedChunks.chunks);
                    ForgeChunkManager.readBlockForcedChunks(modId, chunkPos, modEntry, "TickingBlocks", blockForcedChunks.tickingChunks);
                    ForgeChunkManager.readEntityForcedChunks(modId, chunkPos, modEntry, "Entities", entityForcedChunks.chunks);
                    ForgeChunkManager.readEntityForcedChunks(modId, chunkPos, modEntry, "TickingEntities", entityForcedChunks.tickingChunks);
                }
                continue;
            }
            LOGGER.warn("Found chunk loading data for mod {} which is currently not available or active - it will be removed from the world save.", (Object)modId);
        }
    }

    private static void readBlockForcedChunks(String modId, long chunkPos, CompoundNBT modEntry, String key, Map<TicketOwner<BlockPos>, LongSet> blockForcedChunks) {
        ListNBT forcedBlocks = modEntry.func_150295_c(key, 10);
        for (int k = 0; k < forcedBlocks.size(); ++k) {
            blockForcedChunks.computeIfAbsent(new TicketOwner<BlockPos>(modId, NBTUtil.func_186861_c((CompoundNBT)forcedBlocks.func_150305_b(k))), owner -> new LongOpenHashSet()).add(chunkPos);
        }
    }

    private static void readEntityForcedChunks(String modId, long chunkPos, CompoundNBT modEntry, String key, Map<TicketOwner<UUID>, LongSet> entityForcedChunks) {
        ListNBT forcedEntities = modEntry.func_150295_c(key, 11);
        for (INBT uuid : forcedEntities) {
            entityForcedChunks.computeIfAbsent(new TicketOwner<UUID>(modId, NBTUtil.func_186860_b((INBT)uuid)), owner -> new LongOpenHashSet()).add(chunkPos);
        }
    }

    public static class TicketTracker<T extends Comparable<? super T>> {
        private final Map<TicketOwner<T>, LongSet> chunks = new HashMap<TicketOwner<T>, LongSet>();
        private final Map<TicketOwner<T>, LongSet> tickingChunks = new HashMap<TicketOwner<T>, LongSet>();

        public Map<TicketOwner<T>, LongSet> getChunks() {
            return Collections.unmodifiableMap(this.chunks);
        }

        public Map<TicketOwner<T>, LongSet> getTickingChunks() {
            return Collections.unmodifiableMap(this.tickingChunks);
        }

        public boolean isEmpty() {
            return this.chunks.isEmpty() && this.tickingChunks.isEmpty();
        }

        private Map<TicketOwner<T>, LongSet> getTickets(boolean ticking) {
            return ticking ? this.tickingChunks : this.chunks;
        }

        private boolean remove(TicketOwner<T> owner, long chunk, boolean ticking) {
            LongSet ticketChunks;
            Map<TicketOwner<T>, LongSet> tickets = this.getTickets(ticking);
            if (tickets.containsKey(owner) && (ticketChunks = tickets.get(owner)).remove(chunk)) {
                if (ticketChunks.isEmpty()) {
                    tickets.remove(owner);
                }
                return true;
            }
            return false;
        }

        private boolean add(TicketOwner<T> owner, long chunk, boolean ticking) {
            return this.getTickets(ticking).computeIfAbsent(owner, o -> new LongOpenHashSet()).add(chunk);
        }
    }

    public static class TicketOwner<T extends Comparable<? super T>>
    implements Comparable<TicketOwner<T>> {
        private final String modId;
        private final T owner;

        private TicketOwner(String modId, T owner) {
            this.modId = modId;
            this.owner = owner;
        }

        @Override
        public int compareTo(TicketOwner<T> other) {
            int res = this.modId.compareTo(other.modId);
            return res == 0 ? this.owner.compareTo(other.owner) : res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TicketOwner that = (TicketOwner)o;
            return Objects.equals(this.modId, that.modId) && Objects.equals(this.owner, that.owner);
        }

        public int hashCode() {
            return Objects.hash(this.modId, this.owner);
        }
    }

    public static class TicketHelper {
        private final Map<BlockPos, Pair<LongSet, LongSet>> blockTickets;
        private final Map<UUID, Pair<LongSet, LongSet>> entityTickets;
        private final ForcedChunksSaveData saveData;
        private final String modId;

        private TicketHelper(ForcedChunksSaveData saveData, String modId, Map<BlockPos, Pair<LongSet, LongSet>> blockTickets, Map<UUID, Pair<LongSet, LongSet>> entityTickets) {
            this.saveData = saveData;
            this.modId = modId;
            this.blockTickets = blockTickets;
            this.entityTickets = entityTickets;
        }

        public Map<BlockPos, Pair<LongSet, LongSet>> getBlockTickets() {
            return this.blockTickets;
        }

        public Map<UUID, Pair<LongSet, LongSet>> getEntityTickets() {
            return this.entityTickets;
        }

        public void removeAllTickets(BlockPos owner) {
            this.removeAllTickets(this.saveData.getBlockForcedChunks(), owner);
        }

        public void removeAllTickets(UUID owner) {
            this.removeAllTickets(this.saveData.getEntityForcedChunks(), owner);
        }

        private <T extends Comparable<? super T>> void removeAllTickets(TicketTracker<T> tickets, T owner) {
            TicketOwner<T> ticketOwner = new TicketOwner<T>(this.modId, owner);
            if (tickets.chunks.containsKey(ticketOwner) || tickets.tickingChunks.containsKey(ticketOwner)) {
                tickets.chunks.remove(ticketOwner);
                tickets.tickingChunks.remove(ticketOwner);
                this.saveData.func_76186_a(true);
            }
        }

        public void removeTicket(BlockPos owner, long chunk, boolean ticking) {
            this.removeTicket(this.saveData.getBlockForcedChunks(), owner, chunk, ticking);
        }

        public void removeTicket(UUID owner, long chunk, boolean ticking) {
            this.removeTicket(this.saveData.getEntityForcedChunks(), owner, chunk, ticking);
        }

        private <T extends Comparable<? super T>> void removeTicket(TicketTracker<T> tickets, T owner, long chunk, boolean ticking) {
            if (tickets.remove(new TicketOwner<T>(this.modId, owner), chunk, ticking)) {
                this.saveData.func_76186_a(true);
            }
        }
    }

    @FunctionalInterface
    public static interface LoadingValidationCallback {
        public void validateTickets(ServerWorld var1, TicketHelper var2);
    }
}

